/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlmock;

import java.sql.*;
import java.util.logging.*;
/**
 * Created on 2006/02/13
 */
public class MockPreparedStatement implements PreparedStatement  {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.sql");
  
  int type = 0;
  Connection connection = null;
  PreparedStatement ps = null;
  ResultSet rs = null;

  final int MAX_COLUMNS = 5;

  public MockPreparedStatement() {
  }
  /**
   * Creates a new instance of PreparedStatementProxy
   */
  public MockPreparedStatement(Connection con, PreparedStatement ps, ResultSet rs) {
    this.connection = con;
    this.ps = ps;
    this.rs = rs;
  }

  //--------------------------------------------- 
  String lastSetString = "not setString";
  String[] setStringArr = new String[]{"not set", "not set", "not set", "not set", "not set"};

    
  public void setString(int n, String value) throws SQLException {
    log.info("setString **** n = " + n);
    lastSetString = value;
    setStringArr[n] = value;
  }

  public String getLastSetString() {
    return lastSetString;
  }

  public String getLastSetString(int n) {
    return setStringArr[n];
  }
  
  //--------------------------------------------- IuWFNg

  public void setNull(int parameterIndex, int sqlType) throws SQLException {
    log.info("setNull ****");
    ps.setNull(parameterIndex, sqlType);
  }

  public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
    ps.setNull(paramIndex, sqlType, typeName);
  }
  
  public void setFloat(int parameterIndex, float x) throws SQLException {
    log.info("setFloat ****");
    ps.setFloat(parameterIndex, x);
  }

  //--------------------------------------------- 
  int[] intArr = new int[]{-99, -99, -99, -99, -99};
  
  public void setInt(int parameterIndex, int x) throws SQLException {
    log.info("setInt ****");
    intArr[parameterIndex] = x;
  }

  //--------------------------------------------- O
  long[] longArr = new long[]{-99, -99, -99, -99, -99};
  
  public void setLong(int parameterIndex, long x) throws SQLException {
    longArr[parameterIndex] = x;
  }

  public long getLong(int parameterIndex) {
    return longArr[parameterIndex];
  }
  
  //--------------------------------------------- t
  Date[] dateArr = new Date[]{null, null, null, null, null};
  
  public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
    dateArr[parameterIndex] = x;
  }
  
  public void setBoolean(int parameterIndex, boolean x) throws SQLException {
    ps.setBoolean(parameterIndex, x);
  }

  public void setBigDecimal(int parameterIndex, java.math.BigDecimal x) throws SQLException {
    ps.setBigDecimal(parameterIndex, x);
  }


  //--------------------------------------------- ^C
  Time[] timeArr = new Time[]{ null, null, null, null, null};


  public void setTime(int parameterIndex, java.sql.Time x) throws SQLException {
    log.info("setTime ****");
    ps.setTime(parameterIndex, x);
  }

  public Time getTime(int parameterIndex) {
    return timeArr[parameterIndex];
  }
  
  //--------------------------------------------- ^CX^v
  Timestamp[] timestampArr = new Timestamp[]{null, null, null, null, null
                                             };
  
  public void setTimestamp(int parameterIndex, java.sql.Timestamp x) throws SQLException {
    log.info("setTimestamp ****");
    timestampArr[parameterIndex] = x;
  }

  public Timestamp getTimestamp(int parameterIndex) {
    return timestampArr[parameterIndex];
  }
  
  //--------------------------------------------- IuWFNg
  Object lastSetObject = "not setString";
  
  public void setObject(int parameterIndex, Object x) throws SQLException {
    log.info("setObject *** x = '" + x + "'");
    lastSetObject = x;
  }

  public Object getLastSetObject() {
    return lastSetObject;
  }
  
  public void addBatch() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void addBatch(String sql) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void cancel() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void clearBatch() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void clearParameters() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void clearWarnings() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void close() throws SQLException {
    log.info("close ****");
  }

  public boolean execute() throws SQLException {
    log.info("execute ****");
    return true;
  }

  public boolean execute(String sql) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":execute(1)", sql);
    //if (type == SQLProxyConfig.TRACE_PROXY) {
    return ps.execute(sql);
    //} else {
    //  return true;
    //}
  }

  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":execute(2)", sql);
    return ps.execute( sql, autoGeneratedKeys);
  }

  public boolean execute(String sql, String[] columnNames) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":execute(3)", sql);
    return ps.execute( sql,  columnNames);
  }

  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    return ps.execute(sql,  columnIndexes);
  }

  public int[] executeBatch() throws SQLException {
    return ps.executeBatch();
  }

  
  public ResultSet executeQuery() throws SQLException {
    
    log.info("executeQuery͂܂");
    return new MockResultSet();
  }

  public ResultSet executeQuery(String sql) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":executeQuery(2)", sql);
    ResultSet rc = null;
    try {
      rc = ps.executeQuery(sql);
    } catch (SQLException sqle) {
      //config.trace("PreparedStatementProxy:" + hashCode() + ":executeQuery(2)", sqle);
      throw sqle;
    }
    return rc;
  }

  int countOfexecuteUpdateCalled = 0;
  
  public int executeUpdate() throws SQLException {
    
    log.info("executeUpdate  ---- ENTER");
    countOfexecuteUpdateCalled++;
    return 1;
  }

  public int countOfexecuteUpdateCalled() {
    return countOfexecuteUpdateCalled;
  }



  
  public int executeUpdate(String sql) throws SQLException {
    log.info("executeUpdate:***************");
    return 1;
  }

  public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Connection getConnection() throws SQLException {
    return connection;
  }

  public int getFetchDirection() throws SQLException {
    return ps.getFetchDirection();
  }

  public int getFetchSize() throws SQLException {
    return ps.getFetchSize();
  }

  public ResultSet getGeneratedKeys() throws SQLException {
    return ps.getGeneratedKeys() ;
  }

  public int getMaxFieldSize() throws SQLException {
    return ps.getMaxFieldSize();
  }

  public int getMaxRows() throws SQLException {
    return ps.getMaxRows();
  }

  public ResultSetMetaData getMetaData() throws SQLException {
    return ps.getMetaData();
  }

  public boolean getMoreResults() throws SQLException {
    return ps.getMoreResults();
  }

  public boolean getMoreResults(int current) throws SQLException {
    return ps.getMoreResults(current);
  }

  public ParameterMetaData getParameterMetaData() throws SQLException {
    return ps.getParameterMetaData();
  }

  public int getQueryTimeout() throws SQLException {
    return ps.getQueryTimeout();
  }

  public ResultSet getResultSet() throws SQLException {
    return ps.getResultSet();
  }

  public int getResultSetConcurrency() throws SQLException {
    return ps.getResultSetConcurrency();
  }

  public int getResultSetHoldability() throws SQLException {
    return ps. getResultSetHoldability();
  }

  public int getResultSetType() throws SQLException {
    return ps.getResultSetType();
  }

  public int getUpdateCount() throws SQLException {
    return ps.getUpdateCount();
  }

  public SQLWarning getWarnings() throws SQLException {
    return ps. getWarnings();
  }

  public void setArray(int i, Array x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
    throw new UnsupportedOperationException();
  }


  public void setBinaryStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setBlob(int i, Blob x) throws SQLException {
    throw new UnsupportedOperationException();
  }


  public void setByte(int parameterIndex, byte x) throws SQLException {
    ps.setByte(parameterIndex, x);
  }

  public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    ps.setBytes(parameterIndex, x);
  }

  public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setClob(int i, Clob x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setCursorName(String name) throws SQLException {
    ps.setCursorName(name);
  }


  public void setDate(int parameterIndex, java.sql.Date x, java.util.Calendar cal) throws SQLException {
    ps.setDate(parameterIndex, x, cal);
  }

  public void setDouble(int parameterIndex, double x) throws SQLException {
    ps.setDouble(parameterIndex, x);
  }

  public void setEscapeProcessing(boolean enable) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setFetchDirection(int direction) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setFetchSize(int rows) throws SQLException {
    throw new UnsupportedOperationException();
  }


  public void setMaxFieldSize(int max) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setMaxRows(int max) throws SQLException {
    throw new UnsupportedOperationException();
  }



  public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    ps.setObject(parameterIndex, x, targetSqlType);
  }

  public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
    ps.setObject(parameterIndex, x, targetSqlType, scale);
  }

  public void setQueryTimeout(int seconds) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setRef(int i, Ref x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setShort(int parameterIndex, short x) throws SQLException {

    ps.setShort(parameterIndex, x);
  }


  public void setTime(int parameterIndex, java.sql.Time x, java.util.Calendar cal) throws SQLException {
    ps.setTime(parameterIndex, x, cal);
  }


  public void setTimestamp(int parameterIndex, java.sql.Timestamp x, java.util.Calendar cal) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setURL(int parameterIndex, java.net.URL x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
	    throw new UnsupportedOperationException();
  }
}
