/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlex;

import java.sql.*;
import java.util.logging.*;
/**
 * Created on 2006/02/12
 */
public class ConnectionProxy implements Connection  {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.connection.Proxy");

  Connection con = null;

  /**
   * Creates a new instance of ConnectionProxy
   */
  public ConnectionProxy(Connection con) {
    this.con = con;
  }
  // ----------------------------------------------------------- implements of Connection interface
  public void clearWarnings() throws SQLException {
    con.clearWarnings();
  }

  public void close() throws SQLException {
    if (con == null) throw new IllegalStateException("closeĂ܂");
    con.close();
    log.info("connection " + con.hashCode() + "  close ܂");
    con = null;
  }

  public void commit() throws SQLException {
    con.commit();
  }

  public Statement createStatement() throws SQLException {
    Statement st = con.createStatement();
    return st;
  }

  public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
    Statement st = con.createStatement(resultSetType, resultSetConcurrency);
    return st;
  }

  public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    Statement st = con.createStatement(resultSetType, resultSetConcurrency,resultSetHoldability);
    return st;
  }

  public boolean getAutoCommit() throws SQLException {
    return con.getAutoCommit();
  }

  public String getCatalog() throws SQLException {
    return con.getCatalog();
  }

  public int getHoldability() throws SQLException {
    return con.getHoldability();
  }

  public DatabaseMetaData getMetaData() throws SQLException {
    return con.getMetaData();
  }

  public int getTransactionIsolation() throws SQLException {
    return con.getTransactionIsolation();
  }

  public java.util.Map getTypeMap() throws SQLException {
    return con.getTypeMap();
  }

  public SQLWarning getWarnings() throws SQLException {
    return con.getWarnings();
  }

  public boolean isClosed() throws SQLException {
    return con.isClosed();
  }

  public boolean isReadOnly() throws SQLException {
    return con.isReadOnly();
  }

  public String nativeSQL(String sql) throws SQLException {
    return con.nativeSQL(sql);
  }

  public CallableStatement prepareCall(String sql) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql) throws SQLException {

    PreparedStatement ps = null;
      ps = con.prepareStatement(sql);
    return  ps;
  }

  public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
    PreparedStatement ps = con.prepareStatement(sql, columnNames);
    return  ps;
  }

  public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
    PreparedStatement ps = con.prepareStatement(sql, autoGeneratedKeys);
    return  ps;
  }

  public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
    PreparedStatement ps = con.prepareStatement(sql, columnIndexes);
    return ps;
  }

  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    PreparedStatement ps = con.prepareStatement(sql, resultSetType,resultSetConcurrency);
    return ps;
  }

  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    PreparedStatement ps = con.prepareStatement(sql, resultSetType,resultSetConcurrency,resultSetHoldability);
    return  ps;
  }

  public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    con.releaseSavepoint(savepoint);
  }

  public void rollback() throws SQLException {
    con.rollback();
  }

  public void rollback(Savepoint savepoint) throws SQLException {
    con.rollback(savepoint);
  }

  public void setAutoCommit(boolean autoCommit) throws SQLException {
    con.setAutoCommit(autoCommit);
  }

  public void setCatalog(String catalog) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setHoldability(int holdability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setReadOnly(boolean readOnly) throws SQLException {
    con.setReadOnly(readOnly);
  }

  public Savepoint setSavepoint() throws SQLException {
    return con.setSavepoint();
  }

  public Savepoint setSavepoint(String name) throws SQLException {
    return con.setSavepoint(name);
  }

  public void setTransactionIsolation(int level) throws SQLException {
    con.setTransactionIsolation(level);
  }

  public void setTypeMap(java.util.Map map) throws SQLException {
    con.setTypeMap(map);
  }
}
