/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sql;

import java.util.*;

/**
 * e[u`
 *
 *  Column ̔z
 */
public class MetaDataImpl extends Vector implements MetaData {

  static final long serialVersionUID = 8384632381485662918L;

  private int htmlCounter = 1;
  int nTables = 1;

  public MetaDataImpl() {
  }

  public MetaDataImpl(MetaData meta1, MetaData meta2) {

    addClonedData(meta1);
    addClonedData(meta2);
    tableName = meta1.getTableName() + "_" + meta2.getTableName();
    nTables = 2;
  }

  private void addClonedData(MetaData meta) {

    int n = meta.size();
    for (int i = 0; i < n; i++) {
      HColumn col = (HColumn) meta.get(i);

      HColumn impl = (HColumn) col.clone();
      impl.setHtmlInputTagName("fi" + htmlCounter);
      htmlCounter++;
      add(impl);
    }
  }
  
  public int countTables() {
    return nTables;
  }


  String tableName = null;
  
  public String getTableName() {
    return tableName; 
  }
  
  public void setTableName(String newTableName) {
    tableName = newTableName;
  }

  /**
   *  HTML^O Column 
   */
  public HColumn findByHtmlTagName(String htmlTagName) {

    if (htmlTagName == null) throw new NullPointerException();
    HColumn ans = null;
    int n = size();
    for (int i = 0; i < n; i++) {
      HColumn df = (HColumn) this.get(i);
      if (htmlTagName.equals(df.getHtmlInputTagName())) {

        ans = df;
        break;
      }
    }
    return ans;
  }

  /**
   *  J Column 
   */
  public HColumn findByColumnName(String columnName) {

    if (columnName == null) throw new NullPointerException();
    HColumn ans = null;
    int n = size();

    for (int i = 0; i < n; i++) {
      HColumn df = (HColumn) this.get(i);

      if (columnName.equalsIgnoreCase(df.getColumnName())) { //ORACLE
        ans = df;
        break;
      }
    }
    return ans;
  }

  public List toList() {

    HColumnList vec = new HColumnListImpl();
    for (int i = 0; i < size(); i++) {
      HColumn column = (HColumn) get(i);
      HColumn newCol = (HColumn) column.clone();

      vec.add(newCol);
    }
    return vec;
  }
  

  /** L[݂̂𒊏ozԂ */
  public String[] getKeyList() {

    // L[̐𐔂
    int cnt = 0;
    for (int i = 0; i < size(); i++) {
      HColumn column = (HColumn) get(i);
      if (column.isPrimaryKey()) cnt++;
    }
    String[] ans = new String[cnt];
    int k = 0;
    // L[݂̂ʔzɈڂB
    for (int j = 0; j < size(); j++) {
      HColumn column = (HColumn) get(j);
      if (column.isPrimaryKey()) {
        ans[k] = column.getColumnName();
        k++;
      }
    }
    return ans;
  }

}
