/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sql;

import java.sql.*;
import java.util.logging.*;
/**
 * e[u`̃t@Ng<br>
 *    (NB5 ̃NX  ColumnUtil)
 */
public class MetaDataCreator {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.metadata.Creator");

  public MetaData create(Connection con, String tableName, boolean toLower) throws SQLException {
    if (con == null) throw new NullPointerException();
    return getTableSpec(con.getMetaData(), tableName, toLower);
  }

  public MetaData getTableSpec(DatabaseMetaData meta, String tableName, boolean toLower) throws SQLException {

    MetaDataImpl tableSpec = new MetaDataImpl();
    tableSpec.setTableName(tableName);

    log.info("getTableSpec#tableName =" + tableName);

    ResultSet rs = meta.getColumns(null, null, tableName, "%");
    try {
      int i = 1;
      while (rs.next()) {
        HColumn df = new HColumnImpl();
        df.determineHtmlInputTagName(i);
        df.setTableName(tableName);

        String columnName = rs.getString("COLUMN_NAME");
        if (toLower) columnName = columnName.toLowerCase(); // ORACLE
        df.setColumnName(columnName);
        df.setColumnSize(rs.getInt("COLUMN_SIZE"));

        int sqlType = rs.getInt("DATA_TYPE");
        df.setDataType(sqlType);

        int nullable = rs.getInt("NULLABLE");
        /*
          columnNoNulls - NULL lȂ\
          columnNullable - K NULL l
          columnNullableUnknown - NULL lǂ͕s
         */
        if (nullable != 0) {
          df.setNullable(true);
        } else {
          df.setNullable(false);
        }
        tableSpec.add(df);
        i++;
      }
    } finally {
      rs.close();
    }

    ResultSet rsKey = meta.getPrimaryKeys(null, null, tableName);
    try {
      while (rsKey.next()) {

        String column_name = rsKey.getString("COLUMN_NAME");
        HColumn cs = tableSpec.findByColumnName(column_name);
        cs.setPrimaryKey(true);
      }
    } finally {
      rsKey.close();
    }
    return tableSpec;
  }

}
