/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sql;

import java.util.*;
/**
 */
public class HColumnListImpl extends ArrayList implements HColumnList {

  static final long serialVersionUID = -5324804038613828660L;

  public HColumn findByColumnName(String columnName) {

    for (int i = 0; i < size(); i++) {
      HColumn column = (HColumn) get(i);
      String wk = column.getColumnName();

      if (columnName != null) {
        if (columnName.equals(wk)) {
          return column;
        }
      }
    }
    return null;
  }



  public HColumn addColumn(String tableName, String columnName, 
                                      Object value) {
    HColumnImpl col = new HColumnImpl();
    col.setTableName(tableName);
    col.setColumnName(columnName);
    col.setValue(value);
    this.add(col);
    return col;
  }

  public HColumn addColumn(String tableName, String columnName, 
                           int dataType, Object defaultValue) {
    HColumnImpl col = new HColumnImpl();
    col.setTableName(tableName);
    col.setColumnName(columnName);
    col.setDataType(dataType);
    col.setDefaultValue(defaultValue);
    this.add(col);
    return col;
  }


}
