/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.lru;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.*;
/**
 * Created on 2007/05/30,
 */
public class SqlQueryDaoImpl implements SqlQueryDao {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.lru.SqlQueryDaoImpl");

  Connection con = null;
  /** Creates a new instance of SqlQueryDaoImpl */
  public SqlQueryDaoImpl() {
  }

  public SqlQueryDaoImpl(Connection con) {
    this.con = con;
  }

  public Object queryForList(String query) throws Exception {

    List list = new ArrayList();
    Statement st = con.createStatement();
    try {
      ResultSet rs = st.executeQuery(query);
      try {
        log.info("34) " + query);
        while (rs.next()) {
          log.info("36) rs.next()");
          
          LinkedHashMap hm = new LinkedHashMap();
          ResultSetMetaData meta = rs.getMetaData();
          int n = meta.getColumnCount();
          for (int i = 1; i <= n; i++) {
            String name = meta.getColumnName(i);
            Object obj = rs.getObject(i);
            hm.put(name, obj);
          }

          list.add(Collections.unmodifiableMap(hm));
        }
      } finally {
        rs.close();
      }
    } finally {
      st.close();
    }
    return Collections.unmodifiableList(list);
  }

  public void close() {
    try {
      con.close();
    } catch (Exception ex) {
      throw new RuntimeException(ex);  
    }
  }

}
