/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.lru;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.*;
import java.sql.SQLException;
/**
 * Created on 2007/03/01
 */
public class SqlQueryCacheImpl implements SqlQueryCache {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.lru.SqlQueryCacheImpl");

  DbmsDialect dialect = null;
  LruCacheController lruCacheController = new LruCacheController();
  SqlQueryDaoFactory daoFactory = null;

  /** RXgN^ */
  public SqlQueryCacheImpl() {
  }
  public void setSqlQueryDaoFactory(SqlQueryDaoFactory value) {
    daoFactory = value;
  }
  public void setDbmsDialect(DbmsDialect dialect) {
    this.dialect = dialect;
  }

  public String getHtml() {
        return lruCacheController.getHtml();
  }

  
  /**
   *  JEgSQLsAʂ ht ɓB
   */
  public synchronized Object queryForList(String selectSql) throws SQLException {

    return internalQuery(selectSql);
  }

  /**
   *  JEgSQLsAʂ ht ɓB
   */
  public synchronized Object queryForList(String selectSql, int limit, int offset) throws SQLException {

    String sql = dialect.getLimitString(selectSql, limit, offset);

    return internalQuery(sql);
  }

  private Object internalQuery(String sql) throws SQLException {

    log.info("41) SQL ;" + sql);
    GregorianCalendar now = new GregorianCalendar();
    Object wk = lruCacheController.getObject(null, sql);
    if (wk != null) {
      log.info("LbVɌ܂");
      SqlResultBean bean = (SqlResultBean) wk;
      if (! needReflesh(bean.getCreatedTime(), now)) {
        log.info("LbVԂ܂");
        bean.increment(); // count++
        return bean.getValue();
      } else {
        log.info("LbVɌ܂AÂf[^ł");
      }
    }
    log.info("sqls܂");
    SqlQueryDao dao = this.daoFactory.getSqlQueryDao();
    try {
      SqlResultBean result = executeSqlAndStoreToCache(dao, sql, now);
      wk = result.getValue();
    } finally {
      dao.close();
    }
    return wk;
  }

  private SqlResultBean executeSqlAndStoreToCache(SqlQueryDao dao, String sql,Calendar now
                                                  ) throws SQLException {

    long startTime = System.currentTimeMillis();
    Object result =  null;
    try {
      result =  dao.queryForList(sql); //////////
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    long endTime = System.currentTimeMillis();
    long diffTime = endTime - startTime;
    log.info("s = " + diffTime);

    SqlResultBean countBean = new SqlResultBean(result, sql, now);
    // sʂL܂
    countBean.setExecutionTime(diffTime);
    Object key = sql;
    lruCacheController.putObject(null, key, countBean);
    return countBean;
  }

  private boolean needReflesh(Calendar refleshedTime,Calendar now) {

    // ܂caǂ܂ĂȂ΁AcaǂޕKv
    if (refleshedTime == null) return true;

    // i~bj
    long diffMilliSec = Math.abs(now.getTimeInMillis() - refleshedTime.getTimeInMillis());

    if (diffMilliSec / 1000 / 60 / 5 > 0) {
      // To߂caǂݒ  -- fobO͂P
      return true;
    }
    return false;
  }


}
