/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hiberlike.impl01;

import dwarf.sql.MetaData;
import dwarf.sql.MetaDataCreator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.*;
import javax.sql.DataSource;

import java.util.logging.*;
/**
 * Created on 2007/03/09
 */
public class MetaDataCacheMap implements Map {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.metadata.CacheMap");
  
  DataSource ds = null;
  Map hashtable = null;
  
  /** RXgN^ */
  public MetaDataCacheMap(DataSource ds, Map outerMap) {
    this.ds = ds;
    this.hashtable = outerMap;
  }
  
  public Object get(Object key) {

    if (key == null) throw new NullPointerException("tableName");
    String tableName = (String) key;
    MetaData ans = null;
    try {
      Object obj = hashtable.get(tableName);
      if (obj != null) {
        log.fine(" (37) LbVɌ܂ use cached data ..... table name = " + tableName);
        ans = (MetaData) obj;
      } else {
        if (ds == null) throw new NullPointerException();
        Connection con = ds.getConnection();
        if (con == null) throw new NullPointerException();
        try {
          log.fine(" (44)  read database meta data ..... table name = " + tableName);
          boolean toLower = false; //(dataSource instanceof TableNameUpperCase) ? true : false;
          ans = new MetaDataCreator().create(con, tableName, toLower);
          hashtable.put(tableName, ans);
        } finally {
          con.close();
        }
      }
    } catch (SQLException sqle) {
      throw new RuntimeException(sqle);
    }
    return ans;
  
  }

  
  
  //------------------------------------------------
  
  public Object remove(Object key) {
    throw new UnsupportedOperationException();
  }

  public boolean containsValue(Object value) {
    throw new UnsupportedOperationException();
  }

  public boolean containsKey(Object key) {
    throw new UnsupportedOperationException();
  }

  public void putAll(Map t) {
    throw new UnsupportedOperationException();
  }

  public Collection values() {
    throw new UnsupportedOperationException();
  }

  public int size() {
    throw new UnsupportedOperationException();
  }

  public Object put(Object key, Object value) {
    throw new UnsupportedOperationException();
  }

  public Set keySet() {
    throw new UnsupportedOperationException();
  }

  public boolean isEmpty() {
    throw new UnsupportedOperationException();
  }

  public Set entrySet() {
    throw new UnsupportedOperationException();
  }

  public void clear() {
    throw new UnsupportedOperationException();
  }
  
}
