/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hibermock;

import dwarf.hiberlike.HibSession;
import dwarf.sql.HColumn;
import dwarf.sql.HColumnImpl;
import dwarf.sql.HColumnListImpl;
import java.sql.Types;
import java.util.List;
/**
 */
public class TestDataFactory {

  static final String SCHEMA = "schema01";
  static final String TABLE = "table01";
  

  public static List getTestData01() {
    HColumnListImpl list = new HColumnListImpl();

    list.add(createColumn(SCHEMA, TABLE, "col01", true,   4, "f01", Types.INTEGER, false));
    list.add(createColumn(SCHEMA, TABLE, "col02", false, 20, "f02", Types.VARCHAR,  true));

    return list;
  }


  public static HColumn createColumn(String schemaName, String tableName, 
                                    String columnName, boolean primaryKey,
                                    int columnSize, String htmlInputTagName,
                                    int dataType, boolean nullable) {
    HColumnImpl col = new HColumnImpl();
    col.setSchemaName(schemaName);
    col.setTableName(tableName);
    col.setColumnName(columnName);
    col.setPrimaryKey(primaryKey);
    col.setColumnSize(columnSize);
    col.setHtmlInputTagName(htmlInputTagName);
    col.setDataType(dataType);
    col.setNullable(nullable);
    
    return col;
  }


  public static List getTestData02() {
    HColumnListImpl list = new HColumnListImpl();

    list.add(createColumn2(SCHEMA, TABLE, "col01", true,   4, "f01", Types.INTEGER, false, new Integer(234)));
    list.add(createColumn2(SCHEMA, TABLE, "col02", false, 20, "f02", Types.VARCHAR,  true, "jkl"));

    return list;
  }

  
  
  
  public static HColumn createColumn2(String schemaName, String tableName, 
                                    String columnName, boolean primaryKey,
                                    int columnSize, String htmlInputTagName,
                                    int dataType, boolean nullable,
                                      Object value) {
    HColumnImpl col = new HColumnImpl();
    col.setSchemaName(schemaName);
    col.setTableName(tableName);
    col.setColumnName(columnName);
    col.setPrimaryKey(primaryKey);
    col.setColumnSize(columnSize);
    col.setHtmlInputTagName(htmlInputTagName);
    col.setDataType(dataType);
    col.setNullable(nullable);
    col.setValue(value);
    
    return col;
  }
  


  public static void createTestCase(int testCase, HibSession instance, List list) {
    
    switch (testCase) {
      case 1:
        instance.setValue(list,0,"23");// integer
        instance.setValue(list,1,"123456789.123");//numeric
        instance.setValue(list,2,"49aa");//varchar
        instance.setValue(list,3,"1234");//char(4)
        instance.setValue(list,4,"text");//text
        instance.setValue(list,5,"true");//bool
        instance.setValue(list,6,"2006-1-2");//date
        instance.setValue(list,7,"10:11:12");//time
        instance.setValue(list,8,"2006-1-2 10:11:12");//timestamp
        break;
      case 2:
        instance.setValue(list,0,"34");
        break;
      case 3:
        instance.setValue(list,0,"34");
        instance.setValue(list,1,"49");
        instance.setValue(list,2,"49aax");
        instance.setValue(list,3,"49");
        instance.setValue(list,4,"49aax");
        break;
      case 4:
        instance.setValue(list,0,"34");
        instance.setValue(list,1,"49");
        instance.setValue(list,2,"49aax");
        instance.setValue(list,3,"49");
        instance.setValue(list,4,null); // nou null ɑȂ̂ŁA
        break;
    }
  }


}
