/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hibermock;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.*;
import javax.sql.DataSource;
/**
 * 
 */
public class MockHibSessionFactory implements HibSessionFactory {
    
    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("dwarf.hibermock");
    
    MockHibSession session = null;
    
    Map selectByKeyResult = null;
    
    public void setSelectByKeyResult(Map result) {
        selectByKeyResult = result;
    }
    
    int count = 0;
    
    public HibSession openSession() {
        
        session = new MockHibSession();// eXgR[hpɁAۑ
        session.listForNew = this.listForNew;
        session.selectByKeyResult = this.selectByKeyResult;
        count++;
        log.info(" openSession " + Integer.toHexString(session.hashCode()));
        return session;
    }
    /** eXgR[hpAŌɍ쐬HibSessionԂ */
    public HibSession getLastCreatedSession() {
        return session;
    }
    
    
    public HibSession createSession(Connection con) {
        return openSession();
    }
    
    List listForNew = null;
    
    /** createListForNew \bhĂ΂ꂽƂɕԂListZbg */
    public void setListForNew(List newValue) {
        listForNew = newValue;
    }
    
    
    public int getCountOfOpenSessionCalled() {
        return count;
    }
    
    
    public void setMetaDataCache(Object mc) {
        throw new UnsupportedOperationException();
    }
    
    public HibSession getSession(Connection connection) {
        throw new UnsupportedOperationException();
    }
    
    public HibSession getSession() {
        throw new UnsupportedOperationException();
    }
    
    public void setDataSource(DataSource ds) {
        throw new UnsupportedOperationException();
    }
}
