/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hibermock;

import dwarf.hiberlike.HibSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.*;
/**
 *  MockHibSession  Mock
 */
public class MockHibSession implements HibSession {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("dwarf.hibermock");

  public void log(String msg) {
    log.info(msg);
  }
  
  public List getMetaDataList(Map relation) {
    log.info(" getMetaDataList**********");
    return null;
  }  
  
  public PreparedStatement prepareStatement(String sql) {
    log.info(" prepareStatement**********");
    return null;
  }
  
  public void enableSqlLog(boolean b) {
  }
/*
  public List executeQuery(SQLWithValues swv) {
    log.info(" executeQuery**********");
    return null;
  }
  */
  //--------------------------------------------------------

  Map dbaShowList_relation = null;
  Map dbaShowList_orderBy = null;
  
  List list1 = new ArrayList();
  List list2 = new ArrayList();
  
  public void setDbaShowList(List list1, List list2) {
    this.list1 = list1;
    this.list2 = list2;
  }
  
  public Object[] dbaShowList(Map relation, Map orderBy) {
    log.info(" dbaShowList**********");

    dbaShowList_relation = relation; // eXgR[hŃ`FbN邽߂Ɉۑ
    dbaShowList_orderBy = orderBy;
    
    return new Object[]{list1, list2};
  }

  public Map getDbaShowListRelation() {
    return dbaShowList_relation;
  }

  public Map getDbaShowListOrderBy() {
    return dbaShowList_orderBy;
  }
  
  //--------------------------------------------------------

  public void setValue(List list, int i, Object obj) {
    log.info(" setValue**********");
  }

  List listForEdit = new ArrayList();
  
  public List createListForEdit(Map relation, Map requestMap) {
    log.info(" createListForEdit**********");

    log.info(" createListForEdit = " + relation);
    log.info(" createListForEdit = " + requestMap);

    return listForEdit;
  }

  public void setListForEdit(List newValue) {
    listForEdit = newValue;
  }
  //--------------------------------------------------------
  List listForNew = null;
  Map relation_createListForNew = null;

  public Map getCreateListForNewArg() {
    return relation_createListForNew;
  }
  
  public List createListForNew(Map relation) {
    log.info(" createListForNew**********");
    relation_createListForNew = relation;
    if (listForNew != null) return listForNew;
    return new ArrayList();
  }

  public void setCreateListForNew(List newValue) {
    listForNew = newValue;
  }

  
  //--------------------------------------------------------
  ArrayList forList = new ArrayList();
  
  public List list(Map relation, Map parameter) {
    log.info(" list***********");
    return forList;
  }

  //--------------------------------------------------------
  public int delete(List list) {
    log.info(" delete***********");
    return 1;
  }
  //--------------------------------------------------------
  List insertList = null;

  public int insert(List list) {
    log.info(" insert***********");
    insertList = list;
    return 1;
  }
  public List getLastInsertList() {
    return insertList;
  }

  //--------------------------------------------------------
  public int update(List list) {
    log.info(" update***********");
    return 1;
  }

  //--------------------------------------------------------
  List updateOrInsertList = null;
  
  public void updateOrInsert(List list) {
    log.info(" updateOrInsert***********");
    log.info(" updateOrInsert = " + list);
    
    updateOrInsertList = list;
  }

  public List getLastUpdateOrInsertList() {
    return updateOrInsertList;
  }

  //--------------------------------------------------------
  public void close() {
    log.info(" close " + Integer.toHexString(hashCode()));
  }

  public Connection getConnection() {
    log.info(" getConnection***********");
    return null;
  }

  public Object getDialect() {
    log.info(" getDialect***********");
    return null;
  }

  boolean bConnected = true;
  
  public boolean isConnected() {
    log.info(" isConnected***********");
    return bConnected;
  }

  public List selectByKey(Map relation, List keyValues) {
    log.info(" selectByKey***********");
    throw new UnsupportedOperationException();
  }

  Map insertArg = null;
  public int insert(Map map) {
    log.info(" insert(Map x) ***********");
    insertArg = map;
    return 1;
  }
  public Map getLastInsertMap() {
    return insertArg;
  }

  //-----------------------------------------------
  Map updateArg = null;
  public int update(Map model) {
    log.info(" update(Map x) ***********");
    updateArg = model;
    return 1;
  }
  public Map getLastUpdateMap() {
    return updateArg;
  }

  //-----------------------------------------------
  Map deleteArg = null;

  public int delete(Map model) {
    log.info(" delete(Map x) ***********");
    deleteArg = model;
    return 1;
  }
  
  public Map getLastDeleteMap() {
    return deleteArg;
  }
  
  //-----------------------------------------------
  Map selectByKeyResult = null;

  public void setSelectByKeyResult(Map newValue) {
    selectByKeyResult = newValue;
  }
  
  public Map selectByKey(Map  keyValues) {
    log.info(" selectByKey(Map x) ** " + keyValues);
    selectByKeyArg = keyValues;
    return selectByKeyResult;
  }  

  Map selectByKeyArg = null;
  
  public Map getLastSelectByKeyMap() {
    return selectByKeyArg;
  }
  
  //-----------------------------------------------
  public void updateOrInsert(Map model) {
    log.info(" updateOrInsert(Map x) ***********");
  }

}
