/*
 
 TopMind jLynx "jLynx JDBC Framework"
 Copyright (c) 2004-2006. TopMind Systems Inc.
 All rights reserved.
 
 This file is part of TopMind jLynx.
 
 TopMind jLynx is free software; you can redistribute it and/or modify
 it under the terms of the License. See website for License.
 
 */
package net.sf.jlynx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/**
 * <p>Generates JavaBean style objects (POJOs) and JSPs based on database tables & fields.
 *
 * <p>$Revision: 51 $<br>
 * $Date: 2006-10-10 13:32:47 -0400 (Tue, 10 Oct 2006) $
 *
 */
public final class Generator {
    
    static int tableCount = 0;
    
    static int progress = 0;
    
    static StringBuffer e = new StringBuffer("");
    
    public static String generateCode(
            String packageName,
            String schema,
            String srcdir,
            String superClass)
            throws Exception {
        
        StringBuffer out = new StringBuffer();
        
        if("".equals(schema))
            schema = null;
        
        e = new StringBuffer();
        
        if (false) {
            System.out.println(srcdir);
            return null;
        }
        
        if (superClass == null)
            superClass = "Object";
        superClass = "extends " + superClass;
        
        boolean jlynx = true;
        String suffix = "";
        if (!(superClass.indexOf("biz.topmind.jlynx") > 1)) {
            jlynx = false;
            suffix = "";
        }
        
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String path = "";
        while (st.hasMoreTokens())
            path += File.separator + st.nextToken();
        
        path += File.separator;
        
        out.append("\n\nTimestamp: " + new Date());
        
        File srcDir = new File(srcdir + File.separator + "src" + File.separator
                + path);
        
        File classes = new File(srcdir + File.separator + "classes");
        File jspDir = new File(srcdir + File.separator + "jsp");
        
        // create src or classes dirs
        classes.mkdirs();
        srcDir.mkdirs();
        jspDir.mkdirs();
        
        out.append("\n\nJSPs will be generated in: "
                + jspDir.getCanonicalPath());
        out.append("\nPOJOs will be compiled in: "
                + classes.getCanonicalPath());
        out.append("\nPOJO source directory: "
                + srcDir.getCanonicalPath() + "\n");
        
        out.append("\nJDBC Driver: " + ConfigParser.getDriver());
        out.append("\nJDBC URL: " + ConfigParser.getUrl());
        out.append("\nJDBC User: " + ConfigParser.getUsername());
        
        String javaCode = "";
        StringBuffer jspCode = new StringBuffer("");
        
        String accessors = "";
        String flds = "";
        if (schema != null)
            out.append("\nFiltering on schema: " + schema);
        
        Set tables = SchemaUtil.getTables(null, schema).keySet();
        // System.out.println(tables);
        
        tableCount = tables.size();
        progress = 0;
        
        Iterator iter = tables.iterator();
        int count = 0;
        while (iter.hasNext()) {
            count++;
            progress++;
            String table = (String) iter.next();
            boolean create = true;
            Map fields = SchemaUtil.getColumns(table);
            String className = StringUtils.capitalize(table, true) + suffix;
            
            javaCode = "/** Java code generated by TopMind jLynx on "
                    + new Date() + " **/\n";
            jspCode = new StringBuffer();
            
            String msg = "\n\r <p> ** JSP code generated by jLynx v1.0 on "
                    + new Date()
                    + " ** </p>\n\r <p> ** Depends on JSTL and Spring 2.0 Tag Libraries ** </p>\n\r";
            
            jspCode
                    .append("<%@ taglib uri=\"http://java.sun.com/jsp/jstl/core\" prefix=\"c\" %>\n\r"
                    + "<%@ taglib uri=\"http://java.sun.com/jsp/jstl/fmt\" prefix=\"fmt\" %>\n\r"
                    + "<%@ taglib uri=\"http://www.springframework.org/tags/form\" prefix=\"form\" %>\n\r"
                    + "<html>\n<head>\n<title>jlynx sample app</title>\n"
                    + "<style> #jlynx { margin-left:15px; background-color:#def; padding: 5px; border:1px solid #9cf; font-size:12px; width:440px; } </style>\n"
                    + "</head>\n<body style='font-family: Verdana; margin: 30px;'>\n");
            jspCode
                    .append("<h1>"
                    + table.toUpperCase()
                    + " Form</h1>" + msg + "\n\r<p><c:out value='${result}' escapeXml='false' /></p>\n"
                    + "<form action='' method='post'>\n\r");
            
            jspCode
                    .append("<p>\n\r <input type='submit' name='action' value='select' />\n\r");
            jspCode
                    .append(" <input type='submit' name='action' value='update' />\n\r");
            jspCode
                    .append(" <input type='submit' name='action' value='insert' />\n\r");
            jspCode
                    .append(" <input type='submit' name='action' value='delete' />\n\r</p>\n\r");
            
            if (packageName != null && !"".equals(packageName)) {
                javaCode += "package " + packageName;
                jspCode.append("<input type='hidden' name='pojo' value='"
                        + packageName + "." + className + "' />\n\r");
                
            } else
                jspCode.append("<input type='hidden' name='pojo' value='"
                        + className + "' />\n\r");
            
            e.append("  <entity class='" + packageName + "." + className
                    + "' name='" + table.toLowerCase() + "' />\n");
            
            jspCode
                    .append("<table border=0 cellpadding=5 cellspacing=2 id='jlynx'>\n\r");
            
            jspCode.append("<tr>\n\r <th> bean property </th>\n\r <th> JSTL text field </th>\n\r <th> Spring 2.0 text field </th>\n\r</tr>\n\r");
            
            javaCode += ";\n\n" + "public class " + className + " "
                    + superClass + " implements java.io.Serializable {\n";
            
            accessors = "";
            flds = "\n";
            
            if (jlynx) {
                
                javaCode += "\n\tpublic " + className + "() {\n\t\tthis(null);";
                
                Map pk = SchemaUtil.getPrimaryKeys(table);
                
                if (pk.size() == 0) {
                    
                    String wrng = "Warning: Table <<"
                            + table
                            + ">> does not have a primary key defined! jLynx requires a primary key.";
                    out.append(wrng);
                    // create = false;
                } // else {
                
                javaCode += "\n\t}";
                javaCode += "\n\n\tpublic "
                        + StringUtils.capitalize(table, true) + suffix
                        + "(String txID) {\n\t\tsuper(\"" + table
                        + "\", txID);\n\t}";
                // System.out.println(keyConstructor);
                // end of jlynx ctor
            }
            
            Iterator iter2 = SchemaUtil.getColumns(table).keySet().iterator();
            while (iter2.hasNext()) {
                String field = (String) iter2.next();
                
                accessors += StringUtils.createAccessor(field, (String) fields
                        .get(field));// name,type
                
                // use JSTL taglib to output db bean values
                String jstlTag = "\"<c:out value='${bean." + field
                        + "}' escapeXml='true'/>\"";
                if (fields.get(field).toString().indexOf("java.sql") != -1)
                    jstlTag = "\"<fmt:formatDate value='${bean." + field
                            + "}' type='both' dateStyle='medium'/>\" disabled";
                
                flds += "\n\tprivate " + (String) fields.get(field) + " "
                        + field + ";";
                
                jspCode.append("<tr>\n\r <td id='label'>\n\r\t");
                
                String spring = "\n\r <td id='value'>\n\r\t<form:input path='" + field + "'/>\n\r </td>\n\r";
                jspCode
                        .append(field
                        + "\n\r </td>\n\r <td id='value'>\n\r\t<input type='text' name='"
                        + field + "' value=" + jstlTag
                        + " />\n\r </td>" + spring + "</tr>\n\r");
                
            }
            
            jspCode.append("</table>\n</form>\n</body>\n</html>\n");
            
            // todo - put flds at top
            javaCode += flds + accessors + "\n\n}";
            
            String fileName = srcDir.getCanonicalPath() + File.separator
                    + StringUtils.capitalize(table, true) + suffix + ".java";
            
            if (create) {
                out.append("\n\nCreating.... " + fileName);
                
                File file = new File(fileName);
                if (file.canRead() == false && file.createNewFile()) {
                    FileOutputStream fout = new FileOutputStream(file);
                    fout.write(new String(javaCode).getBytes());
                    fout.flush();
                    fout.close();
                    file = null;
                    
                } else {
                    file = null;
                    System.out
                            .println("Did not create file... source file already exists");
                }
                
                // System.out.println(e.toString());
                
                // write a jsp file now
                // System.out.println(jspCode);
                File file2 = new File(jspDir.getCanonicalPath()
                + File.separator + table + ".jsp");
                if (file2.exists() == false && file2.createNewFile()) {
                    FileOutputStream fout2 = new FileOutputStream(file2);
                    fout2.write(new String(jspCode).getBytes());
                    fout2.flush();
                    fout2.close();
                    out.append("\nCreated JSP: "
                            + file2.getCanonicalPath());
                } else
                    out.append("\nCannot create JSP... file exists");
                
                // try compiling now
                try {
                    
                    String[] args = new String[] { "-classpath", "-g", "-d",
                    classes.getCanonicalPath(), fileName };
                    out.append("\nCompiling... " + fileName);
                    // System.out.println("Compiling... " + args);
                    ClassLoader.getSystemClassLoader().loadClass(
                            "com.sun.tools.javac.Main");
                    com.sun.tools.javac.Main.compile(args, new PrintWriter(
                            System.out));
                    
                } catch (ClassNotFoundException cfne) {
                    out.append("\nError compiling :: Class Not Found... "
                            + cfne.getMessage());
                }
                
            }
            
        }
        
        return out.toString();
    }
}