/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import java.io.IOException;
import java.sql.*;
import java.util.*;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.component.UIComponent;
import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import dwarf.lru.SqlQueryCache;
import java.util.logging.*;
/**
 *  JSTL query
 *   <sql:query var="items" sql="SELECT * FROM PROJECTSCHEMA.ITEMDESC_TBL" />
 *
 *
 */
public class QueryHandler extends TagHandler {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.tag.QueryHandler");

  private final TagAttribute var;

  private final TagAttribute sql;

  private final TagAttribute taLimit;
  
  private final TagAttribute taOffset;

  private final TagAttribute taSession;

  
  /** RXgN^ */
  public QueryHandler(TagConfig config) {
    super(config);
    this.var = this.getRequiredAttribute("var");
    this.sql = this.getRequiredAttribute("sql");
    this.taLimit = this.getAttribute("limit");
    this.taOffset = this.getAttribute("offset");
    this.taSession = this.getAttribute("session");
  }

  /**
   *  SqlQueryCacheImpl ɍ쐬ς݂ł΁AԂB
   *  ܂ĂȂ΁A쐬āAB
   */
  private static SqlQueryCache getSqlQueryCache(Map applicationMap) {

    return (SqlQueryCache) applicationMap.get("SQL_QUERY_CACHE");
  }
  
  public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {

    log.fine(" apply -----------------------------");

    ExternalContext ec = ctx.getFacesContext().getExternalContext();


    Object result = null;
    try {

        SqlQueryCache cache = getSqlQueryCache(ec.getApplicationMap());

        if (log.isLoggable(Level.FINE))
          log.fine("91)  cache =   @"  + Integer.toHexString(cache.hashCode()));

        int limit = 500;
        int offset = 0;

        String strSql = null;
        if (sql != null) strSql = sql.getValue(ctx);

        if (taLimit != null) {
          String strLimit = taLimit.getValue(ctx);
          limit = Integer.parseInt(strLimit);
        }
        
        if (taOffset != null) {
          String strOffset = taOffset.getValue(ctx);
          offset = Integer.parseInt(strOffset);
        }
        
        result = cache.queryForList( strSql, limit, offset);
        
    } catch (SQLException sqle) {
      throw new FacesException(sqle);
    }


    if (taSession != null) {
      String sessionKey = taSession.getValue(ctx);
      ec.getSessionMap().put(sessionKey, result);
      log.fine("128)  ZbVɕۑ܂----------------");
    }
    

    if (this.var != null && result != null) {
      ctx.setAttribute(var.getValue(ctx), result);
    }

    this.nextHandler.apply(ctx, parent);
  }
}
