/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import java.util.Map;
import dwarf.hiberlike.HibSessionFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;
import java.util.logging.*;
/**
 *  HibSessionFactory 
 */
public class FactoryUtil {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.database");
  
  public static HibSessionFactory findHibSessionFactory(FacesContext context) {

    Object fac = context.getExternalContext().getApplicationMap().get("JLYNX_FACTORY");
    return (HibSessionFactory) fac;
  }

  public static Map findTargetMap(FacesContext context, String name) {

    VariableResolver vr = context.getApplication().getVariableResolver();
    log.fine("29) getVariableResolver = " + vr);
    
    Object wk = vr.resolveVariable( context, name);
    return (Map) wk;
 
  }
}
