/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.facelet;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
import java.lang.reflect.Method;
/**
 *
 */
public class DwarfFunctions {


  /**
   *  tNVgetMapĂ
   */
  private static Object getMap(Object target) {

    Class[] args = new Class[0];

    Method method = null;
    try {
      method = target.getClass().getMethod("getMap",  args);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }

    Object ans = null;
    try {
      ans = method.invoke(target, (Object[]) null);
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    return ans;
  }

  /**
   *  ֐ d:metaData 
   */
  public static Object metaData(String name) {

    FacesContext faces = FacesContext.getCurrentInstance();
    ExternalContext ec = faces.getExternalContext();

    Object objMci = ec.getApplicationMap().get("META_DATA_CACHE");
    Map map = (Map) getMap(objMci);
    return map.get(name);
  }


  /**
   *  Escape the 5 entities defined by XML.
   */
  public static String escapeXml(String s) {
    if (s == null) return null;
    StringBuffer sb = new StringBuffer();
    for(int i=0; i<s.length(); i++) {
      char c = s.charAt(i);
      if (c == '<') {
        sb.append("&lt;");
      } else if (c == '>') {
        sb.append("&gt;");
      } else if (c == '\'') {
        sb.append("&apos;");
      } else if (c == '&') {
        sb.append("&amp;");
      } else if (c == '"') {
        sb.append("&quot;");
      } else {
        sb.append(c);
      }
    }
    return sb.toString();
  }

  public static String addTableName(String a, String b) {
    String delim = ".";
    return a + delim + b;
  }

  public static String concat3(String a, String delim, String b) {
    return a + delim + b;
  }

  public static String substring2(String str, int n) {
    return str.substring(n);
  }

  public static String substring3(String str, int a, int b) {
    return str.substring(a, b);
  }
}
