/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.convert;

import dwarf.sql.HColumn;
import javax.faces.application.FacesMessage;
import javax.faces.convert.*;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import java.sql.Types;
import java.math.BigDecimal;
import java.util.logging.*;
/**
 *  f[^x[X^f[^Ŏo ColumnType ɂ
 *  ŃRo[gsRo[^
 */
public class ColumnTypeConverter implements Converter {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.convert.ColumnTypeConverter");

  public static final String CONVERTER_ID = "dwarf.convert.ColumnTypeConverter";

  int      dataType = 0;
  HColumn  hColumn = null;

  public void setDataType(Object obj) {

    if (obj == null) return;
    if (obj instanceof String) {
      String str = (String) obj;
      this.dataType = Integer.parseInt(str);
    } else if (obj instanceof Integer) {
      Integer wk = (Integer) obj;
      this.dataType = wk.intValue();
    } else if (obj instanceof HColumn) {
      this.hColumn = (HColumn) obj;
      this.dataType = hColumn.getDataType();
    } else {
      log.fine("(32) else ");
    }
  }

  /** Ăяon
        at dwarf.convert.ColumnTypeConverter.getAsObject(ColumnTypeConverter.java:49)
        at com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer.getConvertedValue(HtmlBasicInputRenderer.java:180)
        at javax.faces.component.UIInput.getConvertedValue(UIInput.java:733)
        at javax.faces.component.UIInput.validate(UIInput.java:658)
        at javax.faces.component.UIInput.executeValidate(UIInput.java:869)
        at javax.faces.component.UIInput.processValidators(UIInput.java:432)
        at strawberry.lifecycle.ProcessValidationsPhase.recursiveValidate(ProcessValidationsPhase.java:125)

   */
  public Object getAsObject(FacesContext context, UIComponent component, String value) {

    if (context == null || component == null) {
      throw new NullPointerException();
    }

    String componentId = component.getId();

    // If the specified value is null or zero-length, return null
    if (value == null) {
      log.fine("(65) getAsObject => null , id = '" + componentId + "' -----------");
      return null;
    }

    String sw = "";
    Object ans = value;
    switch (dataType) {
    case Types.CHAR:
      sw = "Types.CHAR";
      if (value.length() == 0 && hColumn != null) 
        ans = hColumn.getDefaultValue();
      break;
    case Types.VARCHAR:
      sw = "Types.VARCHAR";
      if (value.length() == 0 && hColumn != null) 
        ans = hColumn.getDefaultValue();
      break;
    case Types.DATE:
      sw = "Types.DATE";
      ans = convertToSqlDate(value);
      break;

    case Types.BIT:
      sw = "Types.BIT";
      break;

    case Types.INTEGER:
      sw = "Types.INTEGER";
      ans = convertToInteger(value);
      break;

    case Types.LONGVARCHAR:
      sw = "Types.LONGVARCHAR";
      break;

    case Types.NUMERIC:
      sw = "Types.NUMERIC";
      ans = convertToBigDecimal(value);
      break;

    case Types.DECIMAL:
      sw = "Types.DECIMAL";
      break;

    case Types.DOUBLE:
      sw = "Types.DOUBLE";
      ans = convertToDouble(value);
      break;

    case Types.TIME:
      sw = "Types.TIME";
      break;

    case Types.TIMESTAMP:
      sw = "Types.TIMESTAMP";
      break;

    case Types.OTHER:
      sw = "Types.OTHER";
      break;

    default:
      sw = "default";
    }

    log.fine("getAsObject => " + ans.getClass().getName() + ", id = '" + componentId +"' ----------");
    return ans;
  }

  public Object convertToSqlDate(String value) {
    Object ans = null;
    try {
      ans = java.sql.Date.valueOf(value);
    } catch (Exception e) {
      throw new ConverterException(new FacesMessage("t"), e);
    }
    return ans;
  }

  public Object convertToInteger(String value) {

    value = value.trim();
    if (value.length() == 0) {
      if (hColumn != null) {
        return hColumn.getDefaultValue();
      } else {
        // 󕶎͂Oɂ
        return new Integer(0);
      }
    }

    Object ans = null;
    try {
      ans = new Integer(Integer.parseInt(value));
    } catch (Exception e) {
      throw new ConverterException(new FacesMessage(""), e);
    }
    return ans;
  }

  public Object convertToDouble(String value) {

    value = value.trim();
    if (value.length() == 0) {
      return hColumn.getDefaultValue();
      // 󕶎͂Oɂ
      //return new Double(0);
    }

    Object ans = null;
    try {
      ans = new Double(Double.parseDouble(value));
    } catch (Exception e) {
      throw new ConverterException(new FacesMessage(""),
                                   e);
    }
    return ans;
  }

  public Object convertToBigDecimal(String value) {

    value = value.trim();
    if (value.length() == 0) {
      return hColumn.getDefaultValue();
      // 󕶎͂Oɂ
      //return new BigDecimal("0");
    }
    
    Object ans = null;
    try {
      ans = new BigDecimal(value);
    } catch (Exception e) {
      throw new ConverterException(new FacesMessage(""),
                                   e);
    }
    return ans;
  }



  /**
   * @exception ConverterException {@inheritDoc}
   * @exception NullPointerException {@inheritDoc}
   */
  public String getAsString(FacesContext context, UIComponent component,
                            Object value) {

    if (context == null || component == null) {
      throw new NullPointerException();
    }

    String componentId = component.getId();
    // If the specified value is null, return a zero-length String
    if (value == null) {
      log.fine("(216) getAsString => '' , id = '" + componentId + "' -----------");
      return "";
    }

    // If the incoming value is still a string, play nice
    // and return the value unmodified
    if (value instanceof String) {
      log.fine("(223) getAsString => " + value + ", id = '" + componentId + "' -----------");
      return (String) value;
    }

    String wk = null;
    try {
      wk = value.toString();
    } catch (Exception e) {
      throw new ConverterException(e);
    }
    log.fine("(233) getAsString => " + wk + ", id = '" + componentId + "' -----------");
    return wk;
  }
}
