/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.component;

import dwarf.facelet.FactoryUtil;
import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import dwarf.hiberlike.HibDuplicateKeyException;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import java.util.logging.*;
/**
 * <p>Implementation of {@link MethodBinding}.</p>
 */

public class OrmMethodBindingImpl extends MethodBinding implements StateHolder {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.database");

  /** RXgN^ */
  public OrmMethodBindingImpl() {
  }

  // --------------------------------------------------- MethodBinding Methods
/*
*/
  String targetMapName = null;

  public void setTargetMap(String x) {
    targetMapName = x;
  }

  String mode = "insert";
  
  public void setMode(String mode) {
    this.mode = mode;
  }

  String successString = null;
  
  public void setSuccessString(String successString) {
    this.successString = successString;
  }

  String failString = null;
  
  public void setFailString(String failString) {
    this.failString = failString;
  }
  
  String successDwarfMode = null;
  
  public void setSuccessDwarfMode(String successString) {
    this.successDwarfMode = successString;
  }

  public Object invoke(FacesContext context, Object params[]) throws EvaluationException, MethodNotFoundException {

    if (context == null) {
      throw new NullPointerException();
    }

    HibSessionFactory hibSessionFactory = FactoryUtil.findHibSessionFactory(context);

    Map targetMap = FactoryUtil.findTargetMap(context, targetMapName);

    
    log.fine("81) invoke " + params + " -----------------");
    log.fine("82) invoke " + targetMap + ",  " + hibSessionFactory);

    if (targetMap == null) {
      log.info("85) return -------------");
      return null;
    }

    if (targetMap.size() == 0) {
      log.info("90) return   size == 0 ");
      return null;
    }

    boolean success = false;

    // OR}bsOEC^[tF[X gāAcaɓo^
//    HibSession session = hibSessionFactory.openSession();    \_ږ
    HibSession session = hibSessionFactory.getSession();    // \.ږ
    try {
      if ("update".equals(mode)) {
        session.update(targetMap);
      } else if ("delete".equals(mode)) {
        session.delete(targetMap);
      } else if ("updateOrInsert".equals(mode)) {
        session.updateOrInsert(targetMap);
      } else {
        session.insert(targetMap);
      }
      success = true;
    } catch (HibDuplicateKeyException dupk) {
      context.addMessage(null, new FacesMessage("ɓo^Ă܂"));
    } catch (Exception ex) {
      context.addMessage(null, new FacesMessage("cao^ɃG["));
      log.log(Level.WARNING, "117) ------------ Exception ", ex);
    } finally {
      session.close();
    }

    if (successDwarfMode != null) {
      if (success) {
        ExternalContext ec = context.getExternalContext();
        String requestServletPath = ec.getRequestServletPath(); //par
        String requestPathInfo = ec.getRequestPathInfo(); //Mxxx
        log.fine("(125)  requestServletPath = " + requestServletPath + ", requestPathInfo = " + requestPathInfo);
        return "/par/Mxxx?dwarfmode=list";
      } else {
        return null;
      }
    } else {
      String outcome = (success) ? successString : failString;
      log.fine("(132)  outcome = " + outcome);
      return outcome;
    }
  }


  public Class getType(FacesContext context) {

    log.info("getType");
    return null;
  }

  public String getExpressionString() {
    log.info("getExpressionString");
    return "getExpressionString";
  }


  // ----------------------------------------------------- StateHolder Methods

  /* gĂȂ
  private Class args[];
  private String name;
  private String rawRef;
  private ValueBinding vb;*/
  
  public Object saveState(FacesContext context) {

    log.info("saveState");

    Object values[] = new Object[4];
    /*
    values[0] = name;
    values[1] = UIComponentBase.saveAttachedState(context, vb);
    values[2] = args;
    values[3] = rawRef;*/
    return (values);
  }


  public void restoreState(FacesContext context, Object state) {
    log.info("restoreState");
/*
    Object values[] = (Object[]) state;
    name = (String) values[0];
    vb = (ValueBinding) UIComponentBase.restoreAttachedState(context,
                                                             values[1]);
    args = (Class[]) values[2];
    rawRef = (String) values[3];*/
  }


  private boolean transientFlag = false;


  public boolean isTransient() {
    return (this.transientFlag);
  }


  public void setTransient(boolean transientFlag) {
    this.transientFlag = transientFlag;
  }
}
