/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.component;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;

import java.util.Map;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.component.html.HtmlCommandButton;
import java.util.logging.*;
/**
 *   HtmlCommandButtonpActionORMappingɂ肩
 *   Created on 2007/03/12
 */
public class OrmCommandButton extends HtmlCommandButton {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.database");

  public OrmCommandButton() {
    super();
    setRendererType("javax.faces.Button");
  }

  /*
   * <p>The standard component type for this component.</p>
   */
   public static final String COMPONENT_TYPE = "javax.faces.HtmlCommandButton";

  /**
   *  JSF 1.1ActionԂ܂B
   *  I JSF ̃o[WオAԂ񏑂Ȃƃ_łB
   */
  public javax.faces.el.MethodBinding getAction() {
    log.info("getAction() -----------------Ă΂܂");
    
    OrmMethodBindingImpl bind = new OrmMethodBindingImpl();

    bind.setTargetMap(getTargetMap());
    bind.setMode(getMode());
    
    bind.setSuccessString(getSuccessString());
    bind.setFailString(getFailString());
    bind.setSuccessDwarfMode(getSuccessDwarfMode());
    return bind;
  }


  String targetMap = null;

  public String getTargetMap() {
    if (null != this.targetMap) {
      return this.targetMap;
    }
    ValueBinding _vb = getValueBinding("targetMap");
    if (_vb != null) {
      log.fine("getValueBinding(targetMap)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }
  
  public void setTargetMap(String newValue) {
    targetMap = newValue;
  }

  //-------------------------------------------------------------

  String mode = null;

  public String getMode() {
    if (null != this.mode) {
      return this.mode;
    }
    ValueBinding _vb = getValueBinding("mode");
    if (_vb != null) {
      log.fine("getValueBinding(mode)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setMode(String newValue) {
    mode = newValue;
  }

  //-------------------------------------------------------------

  String successString = null;

  public String getSuccessString() {
    if (null != this.successString) {
      return this.successString;
    }
    ValueBinding _vb = getValueBinding("successString");
    if (_vb != null) {
      log.fine("getValueBinding(successString)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setSuccessString(String newValue) {
    successString = newValue;
  }

  //-------------------------------------------------------------

  String failString = null;

  public String getFailString() {
    if (null != this.failString) {
      return this.failString;
    }
    ValueBinding _vb = getValueBinding("failString");
    if (_vb != null) {
      log.fine("getValueBinding(failString)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setFailString(String newValue) {
    failString = newValue;
  }

  //-------------------------------------------------------------

  String successDwarfMode = null;

  public String getSuccessDwarfMode() {
    if (null != this.successDwarfMode) {
      return this.successDwarfMode;
    }
    ValueBinding _vb = getValueBinding("successDwarfMode");
    if (_vb != null) {
      log.fine("getValueBinding(successDwarfMode)Ԃ܂");
      return (String) _vb.getValue(getFacesContext());
    } else {
      return null;
    }
  }

  public void setSuccessDwarfMode(String newValue) {
    successDwarfMode = newValue;
  }

}
