/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 */
package dwarf.column;

import dwarf.sql.HColumn;
import java.sql.Types;


/**
 *  column u
 */
public class DescriptionOfColumnImpl implements DescriptionOfColumn {

  /**
   *  ͗̉Eɕ\
   */
  public String getDescriptionOfColumn(HColumn col) {
    String ans = "";

    int type = col.getDataType();
    switch (type) {
      case Types.CHAR:
      case Types.VARCHAR:
      int sz = col.getColumnSize();
      if (sz > 0) {
        ans = " (" + sz + ")";
      } else {
        ans = "";
      }
      break;

    case Types.DATE:
      ans = "t";
      break;
      
    case Types.BIT:
      ans = "_^(t or f)";
      break;

    case Types.INTEGER:
      ans = "";
      break;

    case Types.LONGVARCHAR:
      ans = "";
      break;
      
    case Types.NUMERIC:
      ans = "";
      break;

    case Types.DECIMAL:
      ans = "";
      break;
      
    case Types.DOUBLE:
      ans = "";
      break;

    case Types.TIME:
      ans = "";
      break;
      
    case Types.TIMESTAMP:
      ans = "t";
      break;

    case Types.OTHER:
      ans = "nvarchar2 ?";
      break;

    default:
      ans = "s" + type;
    }
    return ans;
  }
/*
 public static final int ARRAY 2003 
 public static final int BIGINT -5 
 public static final int BINARY -2 
 public static final int BIT -7 
 public static final int BLOB 2004 
 public static final int BOOLEAN 16 
 public static final int CHAR 1 
 public static final int CLOB 2005 
 public static final int DATALINK 70 
 public static final int DATE 91 
 public static final int DECIMAL 3 
 public static final int DISTINCT 2001 
 public static final int DOUBLE 8 
 public static final int FLOAT 6 
 public static final int INTEGER 4 
 public static final int JAVA_OBJECT 2000 
 public static final int LONGVARBINARY -4 
 public static final int LONGVARCHAR -1 
 public static final int NULL 0 
 public static final int NUMERIC 2 
 public static final int OTHER 1111 
 public static final int REAL 7 
 public static final int REF 2006 
 public static final int SMALLINT 5 
 public static final int STRUCT 2002 
 public static final int TIME 92 
 public static final int TIMESTAMP 93 
 public static final int TINYINT -6 
 public static final int VARBINARY -3 
 public static final int VARCHAR 12 
*/


}
