/* -*- Mode: java4; -*-
 
 TopMind jLynx "jLynx JDBC Framework"
 Copyright (c) 2004-2006. TopMind Systems Inc.
 All rights reserved.
 
 This file is part of TopMind jLynx.
 
 TopMind jLynx is free software; you can redistribute it and/or modify
 it under the terms of the License. See website for License.


 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */
package mod.sf.jlynx;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.*;
/**
 * Implementation of Relational interface. Use <code>RelationalFactory</code>
 * to obtain instance.
 *
 * @see biz.topmind.jlynx.Relational
 *
 * $Revision: 73 $ $Date: 2006-11-13 09:58:31 -0500 (Mon, 13 Nov 2006) $
 *
 */
public class RelationalEx implements Relational {

    // jdk1.4 logging
    protected final static Logger logger = Logger.getLogger("strawberry.jlynx.RelationalEx");

    private static List removeProp;

    private static final long serialVersionUID = 1L;

    static {

        // TODO make this XML-configurable
        removeProp = new ArrayList();
        removeProp.add("class");
        removeProp.add("multipartRequestHandler");
        removeProp.add("servletWrapper");
        removeProp.add("entity");
        removeProp.add("bean");
        removeProp.add("validConfig");
        removeProp.add("page");
        removeProp.add("resultValueMap");
        removeProp.add("validatorResults");

    }

    private static String fixNulls(String sqlIn) {
        return StringUtils.replace(sqlIn, "'null'", "NULL");
    }

    private void setSingleRowValues(ResultSet rs) throws Exception {
        if (bean != null && bean instanceof Map) {

            ((Map) bean).clear();

            // assumes a single record
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); i++) {
                ((Map) bean).put(rs.getMetaData().getColumnName(i), rs
                                 .getObject(i));
            }
        }
    }

    /**
     *
     * pre-condition: ResultSet next() called
     *
     * @param rs
     * @param object
     * @return
     * @throws Exception
     */
    private static Object setValues(ResultSet rs, Object object)    throws Exception {

        if (object == null)
            return null;

        try {

            int colCount = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= colCount; i++) {

                String colName = rs.getMetaData().getColumnName(i);

                Object value = rs.getObject(i);

                if (object instanceof Map) {

                    ((Map) object).put(colName, value);

                } else {

                    BeanUtils.setValue(colName, object, value);

                }

            }// end for

        } catch (SQLException e) {
            throw e;
        }
        return object;
    }

    // private member fields
    private boolean autoCommit = true;

    private Object bean;

    Connection conn = null;

    public void setConnection(Connection con) {
      this.conn = con;
    }

    protected int dbVendor;

    private boolean domapping = false;

    private String entityName;

    private boolean initialized = false;

    private boolean keepNullsInQuery = true; // ύX

    private String keyField;

    private String[] keyFields;

    private Map mappings;

    private PreparedStatement ps;

    private ResultSet rs;

    private Statement stmt;

    private boolean validConfig = true;

    private RelationalEx() {
    }

    public RelationalEx(String entity ) {
        setEntity(entity);
    }

    public void commit() {
        if (conn != null) {
            try {
                conn.commit();
                this.autoCommit = true;
                release();
            } catch (SQLException e) {
                logger.log(Level.WARNING, "(229)" + e.getMessage(), e);
            } finally {
                this.autoCommit = true;
                conn = null;
            }
        } else
            logger.warning("(236)Connection already closed!");
    }

    private String createFilterStmt() throws NoSuchMethodException, SQLException {

        // TODO handle Maps for multi-part keys

        String newKey = null;
        if (mappings != null && mappings.containsValue(keyField)) {
            // logger.fine(mappings + keyField);
            Iterator i = mappings.keySet().iterator();
            while (i.hasNext()) {
                newKey = (String) i.next();
                if (keyField.equals(mappings.get(newKey)))
                    break;
                else
                    newKey = null;
            }
        }

        if (newKey != null)
            keyField = newKey;

        String sql = " WHERE ";
        String delimiter = "'";

        Object obj = this.bean;

        if (keyField != null) {

            Object keyVal = null;

            try {

                if (obj instanceof Map) {
                    keyVal = ((Map) obj).get(keyField);
                    if (keyVal == null)
                        keyVal = ((Map) obj).get(keyField.toLowerCase());
                } else {

                    keyVal = BeanUtils.getValue(keyField, obj);

                }

                if (keyVal == null)
                    throw new Exception();

                // fix for DB2 (numbers cannot be wrapped with apostrophe)
                if (DataTypeMappings.isNumber(keyVal))
                    delimiter = "";

            } catch (Exception e) {
                throw new SQLException(
                    "Primary key cannot be determined :: jlynx.xml mapping needed");
            }

            sql += fixUpdateMappings(keyField) + "=" + delimiter
                + keyVal.toString() + delimiter;

            // logger.fine("WHERE clause :: " + sql);

            return sql;

        } else if (keyFields != null) {
            int keySize = keyFields.length;
            for (int i = 0; i < keySize; i++) {
                if (i != 0) {
                    sql += " AND ";
                }
                sql += keyFields[i];

                Object partKeyValue = null;

                if (obj instanceof Map) { // ǉ
                    partKeyValue = ((Map) obj).get(keyFields[i]);
                    if (partKeyValue == null)
                        partKeyValue = ((Map) obj).get(keyFields[i].toLowerCase());
                } else {
                    partKeyValue = BeanUtils.getValue(keyFields[i], obj);
                }
                // DB2 fix as above
                if (DataTypeMappings.isNumber(partKeyValue))
                    delimiter = "";
                else
                    delimiter = "'";
                if (partKeyValue == null) throw new IllegalArgumentException("" + keyFields[i] + " null");
                sql += "=" + delimiter + StringUtils.escapeQuotes( partKeyValue.toString()) + delimiter;
                //                          escape ǉB2007/5/28
            }
        }
        return sql;
    }

    private String createInsertStmt() throws NoSuchMethodException {

        StringBuffer sql = new StringBuffer();

        Map props;
        String delimiter = "'";

        Object obj = bean;

        if (obj instanceof Map)
            props = (Map) obj;
        else
            props = BeanUtils.describe(obj);

        // remove useless properties from this object
        Iterator iter = removeProp.iterator();
        while (iter.hasNext())
            props.remove((String) iter.next());

        // fix to account for identity fields in SQL Server and other
        // default values
        removeNulls(props);

        Iterator i = props.keySet().iterator();
        String fld = null;
        String[] fields = new String[props.size()];
        int j = 0;
        while (i.hasNext()) {
            fld = (String) i.next();

            fields[j] = fld;
            j++;
            // logger.fine(fld);
            sql.append(fld);
            if (i.hasNext()) {
                sql.append(",");
            } else {
                // fix for configured column mappings
                String end = ",$END-OF-COLUMN65$";
                sql.append(end);
                // logger.fine(sql);
                if (domapping)
                    sql = new StringBuffer(fixInsertMappings(sql.toString()));
                // logger.fine(sql);
                sql = new StringBuffer(StringUtils.replace(sql.toString(), end,
                                                           ""));
                sql.append(") VALUES (");
            }
        }

        i = props.values().iterator();
        j = 0;
        while (i.hasNext()) {

            Object val = i.next();
            // logger.fine(val);
            String oracleDate1 = "";
            String oracleDate2 = "";

            if (dbVendor == TransactionManager.ORACLE) {

                // Oracle fix for Dates
                if (java.sql.Timestamp.class.equals(BeanUtils.getType(
                    fields[j], obj))) {
                    // System.out.println(fld);
                    oracleDate1 = "to_date(";
                    oracleDate2 = ",'yyyy-mm-dd hh24:mi:ss\".999\"')";

                }
            }

            if (dbVendor == TransactionManager.MSSQL) {

                // MSSQL fix for Bits/Boolean
                Class cls = BeanUtils.getType(fields[j], obj);

                if (Boolean.class.equals(cls)) {

                    Boolean valB = (Boolean) val;

                    if (valB.booleanValue())
                        val = "1";
                    else
                        val = "0";

                    logger.fine("SQL bit fix :: " + cls);

                } else if (cls == boolean.class) {
                    // boolean bit = ((Boolean) val).booleanValue();
                    if ("true".equals(val.toString()))
                        val = "1";
                    else
                        val = "0";

                    logger.fine("SQL bit fix :: " + cls);
                }

            }

            Object field = null;

            // field = PropertyUtils.getProperty(obj, fields[j]);
            field = BeanUtils.getValue(fields[j], obj);

            if (DataTypeMappings.isNumber(field)) {
                delimiter = "";
            } else
                delimiter = "'";

            j++;

            sql.append(oracleDate1 + delimiter
                       + StringUtils.escapeQuotes(val.toString()) + delimiter
                       + oracleDate2);
            if (i.hasNext()) {
                sql.append(",");
            } else {
                sql.append(")");
            }
        }

        String result = "INSERT INTO " + entityName + " ("
            + fixNulls(sql.toString());

        logger.config("395)INSERT stmt: '" + result + "'");

        return result;
    }

    private String createSelectStmt() throws NoSuchMethodException,            SQLException {

        String cols = fixSelectMappings();

        if (cols.equalsIgnoreCase(""))
            cols = "*";
        else
            cols = entityName + ".*" + cols;

        String sql = "SELECT " + cols + " FROM " + entityName
            + createFilterStmt();

        logger.fine("(478) SELECT SQL statement: '" + sql +"'");

        return sql;
    }

    private String createUpdateStmt() throws Exception {

        String delimiter = "'";
        logger.fine("createUpdateStmt()  entityName '" +  entityName + "'"  );

        String sql = "UPDATE " + entityName + " SET ";

        String where = createFilterStmt();

        logger.fine("WHERE clause: " + where);

        Map map = new TreeMap();

        if (bean instanceof Map) {
            map.putAll((Map) this.bean);
            logger.fine("Map " + map);
        } else
            map.putAll(BeanUtils.describe(bean));

        // remove useless properties from this object
        Iterator iter = removeProp.iterator();
        while (iter.hasNext())
            map.remove((String) iter.next());

        // remove null values from the bean
        removeNulls(map);

        Iterator i = map.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {

            j++;
            String colName = (String) i.next();
            String value = null;
            boolean isMap = bean instanceof Map;
            Object o = null;
            o = map.get(colName);

            if (o != null) {
                value = StringUtils.escapeQuotes(o.toString());
                if (this.keyField != null) {
                    if (colName.equalsIgnoreCase(keyField))
                        value = null;
                } else if (this.keyFields != null) {
                    for (int k = 0; k < keyFields.length; k++) {
                        if (colName.equalsIgnoreCase(keyFields[k]))
                            value = null;
                    }
                } else
                    throw new SQLException(
                        "Primary key(s) is not set for the UPDATE query");// no
                // primary
                // key
            }

            if (value != null) {

                String oracleDate1 = "";
                String oracleDate2 = "";

                if (!isMap && dbVendor == TransactionManager.ORACLE) {

                    // Oracle fix for Dates
                    Class cls = BeanUtils.getType(colName, bean);
                    if (java.sql.Timestamp.class.equals(cls)) {
                        // System.out.println("Oracle Date");
                        oracleDate1 = "to_date(";
                        oracleDate2 = ",'yyyy-mm-dd hh24:mi:ss\".999\"')";

                    }
                }

                if (!isMap && dbVendor == TransactionManager.MSSQL) {

                    Class cls = BeanUtils.getType(colName, bean);

                    // MSSQL fix for Bits/Boolean
                    if (Boolean.class.equals(cls)) {
                        Boolean valB = (Boolean) BeanUtils.getValue(colName,
                                                                    bean);
                        if (valB.booleanValue())
                            value = "1";
                        else
                            value = "0";
                        logger.fine("SQL bit fix :: " + cls);

                    } else if (cls == boolean.class) {

                        if ("true".equals(value.toString()))
                            value = "1";
                        else
                            value = "0";
                        logger.fine("SQL bit fix :: " + cls);
                    }
                }

                // do fix here for DB2 numeric types
                if (!isMap
                    && DataTypeMappings.isNumber(BeanUtils.getValue(
                        colName, bean))) {
                    delimiter = "";
                } else
                    delimiter = "'";

                // logger.fine("Bean:Column pairing: " + colName + "::" +
                // fixUpdateMappings(colName));

                colName = fixUpdateMappings(colName);

                sql += colName + "=" + oracleDate1 + delimiter + value
                    + delimiter + oracleDate2 + ", ";
            }

        }
        if (j == 0) {
            return null;
        }
        //logger.fine("(600) UPDATE stmt: '" + sql + "'");

        // ŁA   sql   = update \ SET aaa=123, bbb=456,
        //            where = where 
        if (sql.endsWith(", ")) {
            // SET ̍Ōɂ] ,ƃXy[XiQj폜āA
            //  wheretB
            sql = sql.substring(0, sql.length() - 2) + where;
        }

        sql = fixNulls(sql);

        logger.config("546) UPDATE stmt: `" + sql + "`");

        return sql;
    }
    // jlynxbooleanԂAԂ悤ɏCĂ܂B
    public final int delete() throws SQLException {

        if (!validConfig) {
            logger.config("(620)jLynx configuration invalid");
            throw new SQLException("jLynx configuration invalid");
        }

        if (!initialized)
            init();
        int result = 0;
        String sql = null;
        try {
            sql = "DELETE FROM " + entityName + createFilterStmt();

            logger.info("(631) " +  sql);
            if (conn == null) {
                //connect();
            }
            stmt = conn.createStatement();
            result = stmt.executeUpdate(sql);


        } catch (Exception e) {
            logger.log(Level.WARNING, "(640) catch Exception:" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else if (e instanceof RuntimeException) {
              throw (RuntimeException) e;
            } else
                throw new SQLException(e.getMessage());
        } finally {
            //logger.fine(sql);
            release();
        }
        return result;
    }

    public boolean execute() throws SQLException {

        logger.fine("execute() ---       Entering");
        boolean result = false;
        if (ps != null)
            result = ps.execute();
        release();
        logger.fine("Exiting");
        return result;

    }

    public List executeQuery() throws SQLException {

        logger.fine("executeQuery() ------ Entering");
        List result = new ArrayList();

        if (ps != null)
            rs = ps.executeQuery();

        while (rs != null && rs.next()) {

            try {

                Object obj;
                if (bean instanceof Class)
                    obj = ((Class) bean).newInstance();
                else
                    obj = bean.getClass().newInstance();
                obj = setValues(rs, obj);
                result.add(obj);

            } catch (Exception e) {
                // TODO
            }
        }

        release();
        logger.fine("Exiting");
        return result;

    }

    private String fixInsertMappings(String sql) {

        if (mappings == null || mappings.isEmpty())
            return sql;

        Iterator iter = mappings.keySet().iterator();
        while (iter.hasNext()) {
            String col = (String) iter.next();
            sql = StringUtils.replace(sql, col + ",", (String) mappings
                                      .get(col)
                                      + ",");
        }
        return sql;

    }

    private String fixSelectMappings() {

        if (mappings != null && !mappings.isEmpty()) {

            String sql = "";
            Iterator iter = mappings.keySet().iterator();
            while (iter.hasNext()) {

                String jCol = (String) iter.next();
                String dbCol = (String) mappings.get(jCol);

                if (jCol != null && dbCol != null)
                    sql += "," + dbCol + " \"" + jCol + "\"";

            }
            return sql;

        } else
            return "";

    }

    private String fixUpdateMappings(String columnName) {

        if (mappings != null && mappings.containsKey(columnName))
            return (String) mappings.get(columnName);
        else
            return columnName;

    }

    // Returns the entityName.
    private final String getEntity() {
        return entityName;
    }

    /*
     * (non-Javadoc)
     *
     * @see biz.topmind.jlynx.Relational#getPreparedStatement(String namedQuery)
     */
    public PreparedStatement getPreparedStatement(String namedQuery)    throws SQLException {
        String sql = null; //ConfigParser.getQuery(namedQuery);
        this.prepareStatement(sql);
        return ps;
    }

    public void setKeyFields(String[] arr) {
        keyFields = arr;
    }
    // initialize; setup primary keys
    private void init() {

        logger.fine("init() ------ Entering");

        // exit if bean is a Map and setEntity() has not been called yet
        if (bean == null
            || (bean instanceof Map && getEntity().equalsIgnoreCase(
                bean.getClass().getName().toString().toLowerCase())))
            return;

        logger.fine("entity = " + getEntity() + " object class = "
                    + bean.getClass());

        String db = null;

        try {

            //this.mappings = (Map) connBean.getMappings().get(this.getEntity());
            logger.fine("Column name mappings :: " + mappings);
            domapping = true;

        } catch (NullPointerException npe) {
            domapping = false;
            mappings = null;
        }

        if (keyField == null && keyFields == null) {

            Object[] keySet;

            /* DatabaseMetaBean dm = (DatabaseMetaBean) SchemaUtil.DATABASE_INFO
                    .get(db); */

            //if (dm == null) {
            logger.warning("(811) Database not configured :: DB alias = " + db);
            validConfig = false;
            return;
            /* }

            this.dbVendor = dm.getDbVendor();

            // make sure we do below in a case-sensitive manner
            // i.e. we put tables in databasemetabean case-sensitive and we
            // fetch case-sensitive
            keySet = (Object[]) dm.getTables().get(getEntity().toLowerCase());

            if (keySet == null || keySet.length == 0) {

                if (!(bean instanceof Map))
                    logger
                        .error("entity named <<"
                            + getEntity()
                            + ">> does not exist or does not have a primary key");

                validConfig = false;

            } else if (keySet.length == 1) {

                // single pri key
                keyField = (String) keySet[0];

                logger.fine("pri key = " + keyField);

                validConfig = true;

            } else {

                // composite pri key
                keyFields = new String[keySet.length];
                for (int i = 0; i < keySet.length; i++)
                    keyFields[i] = (String) keySet[i];

                validConfig = true;

            }
             */
        }

        initialized = true;

    }

    /*
     * (non-Javadoc)
     *
     * @see biz.topmind.jlynx.Relational#insert()
     */
    public final int insert() throws SQLException {

        if (!validConfig) {
            logger.warning("(867) jLynx configuration invalid");
            throw new SQLException("jLynx configuration invalid");
        }

        if (!initialized)
            init();

        int result;
        try {

            String sql = createInsertStmt();
            stmt = conn.createStatement();
            logger.fine(sql);
            result = stmt.executeUpdate(sql); // inserts

            if (dbVendor == TransactionManager.MSSQL && result == 1) {
                try {
                    int ident = 1;
                    String identitySql = "SELECT SCOPE_IDENTITY()";

                    rs = stmt.executeQuery(identitySql);
                    if (rs.next())
                        ident = rs.getInt(1);

                    logger.fine(dbVendor + " : " + identitySql + " = " + ident);

                    result = ident;
                } catch (Exception e) {
                    result = 1;
                }
            } else if (dbVendor == TransactionManager.MYSQL && result == 1) {

                // use mysql last_insert_id() to return the auto_increment value
                // if it returns 0, return 1 instead

                String ident = "";

                rs = stmt.executeQuery("select LAST_INSERT_ID() as ident");
                if (rs.next())
                    ident = rs.getString(1);

                logger.fine("mysql LAST_INSERT_ID() = " + ident);

                try {
                    result = new Integer(ident).intValue();
                    if (result == 0)
                        result = 1;
                } catch (NumberFormatException e) {
                    result = 1;
                }
            }

        } catch (Exception e) {

            logger.log(Level.WARNING, "842) catch Exception " + e.getMessage());

            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else if (e instanceof RuntimeException) {
              throw (RuntimeException) e;
            } else {
                throw new SQLException(e.getMessage());
            }
        } finally {
            release();
        }
        return result;
    }

    // setup PreparedStatement object ps
    private void prepareStatement(String stmt) throws SQLException {

        logger.fine("Fetching PreparedStatement using SQL statement: " + stmt);

        ps = conn.prepareStatement(stmt);

    }

    /*
     * (non-Javadoc)
     *
     * @see biz.topmind.jlynx.Relational#preserveNulls()
     */
    public void saveNulls(boolean updateNulls) {
        this.keepNullsInQuery = updateNulls;
    }

    void refresh(Object object) {

        if (bean == null) {
            bean = object;
            return;
        }

        if (!BeanUtils.describe(object).keySet().equals(
            BeanUtils.describe(bean).keySet())) {
            logger.warning("Attempt to refresh bean failed");
        } else {
            this.bean = object;
        }

    }

    private final void release() throws SQLException {

        logger.fine("AutoCommit = " + this.autoCommit);
        /*
        if (this.ds == null) {
            logger.fine("(980) return");
            return;
        }*/

        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (ps != null) {
                ps.close();
                ps = null;
            }
        } catch (SQLException e) {
            logger.log(Level.WARNING, "(989)" + e.getMessage(),e);
/*
        } finally {
            logger.fine("(992)conn=" + conn);

            if (conn != null && autoCommit) {
                conn.close();
                conn = null;
            }*/
        }
        logger.fine("(999)conn=" + conn);
    }

    private final void removeNulls(Map map) {

        logger.fine("(1004)Keep nulls in SQL query :: " + this.keepNullsInQuery);

        List keysToRemove = new ArrayList();

        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {

            String key = (String) iter.next();

            if (keepNullsInQuery) {

                // for empty Strings put null
                if ("".equals(map.get(key)) || map.get(key) == null) {
                    // logger.fine(key + ":" + map.get(key));
                    map.put(key, "null");
                }

            } else {

                if (map.get(key) == null) {
                    // logger.fine(key + "=" + map.get(key));
                    // remove these in a safe manner 9/12/06
                    keysToRemove.add(key);
                }
            }
        }
        // remove keys from map
        iter = keysToRemove.iterator();
        while (iter.hasNext()) {
            map.remove(iter.next());
        }

    }

    public void rollback() {

        if (conn != null) {

            try {

                conn.rollback();
                this.autoCommit = true;
                release();

            } catch (SQLException e) {
                logger.log(Level.WARNING, "(1049)" + e.getMessage(), e);
            } finally {
                this.autoCommit = true;
            }

        } else
            logger.warning("Connection already closed!");

    }

    /*
     * (non-Javadoc)
     *
     * @see biz.topmind.jlynx.Relational#save()
     */
    public int save() throws SQLException {

        logger.fine("Entering save()");

        int result = 0;

        try {
            result = update();
            if(result == 0)
                throw new SQLException();

        } catch (SQLException ex) {

            result = 0;
            logger.fine("update() failed... now trying to insert record");
            result = insert();
        }

        logger.fine("Exiting save()");
        return result;
    }

    public final boolean select() throws SQLException {

        if (!validConfig) {
            logger.warning("(1090)jLynx configuration invalid :: " + getEntity());
            throw new SQLException("jLynx configuration invalid");
        }

        if (!initialized)
            init();

        String sql = null;

        try {
            boolean result;
            sql = createSelectStmt();

            stmt = conn.createStatement();
            ResultSet resultset = stmt.executeQuery(sql);

            if ((result = resultset.next())) {
                if (bean instanceof Map) {
                    setSingleRowValues(resultset);
                    logger.fine("Map " + bean);
                } else
                    this.bean = setValues(resultset, this.bean);
            }

            logger.fine("(1118) SELECT stmt: `" + sql + "`, result = " + result);

            return result;

        } catch (Exception e) {
            logger.log(Level.WARNING, "(1123)" + e.getMessage(), e);

            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else
                throw new SQLException(e.getMessage());

        } finally {

            release();

        }
    }

    /*
     * (non-Javadoc)
     *
     * @see biz.topmind.jlynx.Relational#setAutoCommit(boolean)
     */
    public void setAutoCommit(boolean b) {

        this.autoCommit = b;

    }

    public void setObject(Object bean) {
        if (!(bean instanceof Map))
            this.bean = bean;
        else
            this.bean = bean;
    }

    public void setEntity(String entity) {

        this.entityName = entity.toLowerCase();//v1.2.1 fix

        // check the mappings and setup the pri key member fields
        // added this 8/22/06
        init();

    }

    public final int update() throws SQLException {

        if (!validConfig)
            throw new SQLException("jLynx configuration invalid");

        if (!initialized)
            init();

        int result = 0;
        String sql = null;
        try {
            sql = createUpdateStmt();

            stmt = conn.createStatement();

            logger.info("(1183) 쐬ꂽUPDATE = " + sql);

            result = stmt.executeUpdate(sql);
        } catch (Exception e) {
            logger.log(Level.WARNING, "(1187) " + e.getMessage(), e);

            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else
                throw new SQLException(e.getMessage());
        } finally {
            release();
        }
        return result;
    }

    public List selectByKey() throws SQLException {
        List ans = null;
        if (!validConfig) {
            logger.config("(1202)jLynx configuration invalid :: " + getEntity());
            throw new SQLException("jLynx configuration invalid");
        }

        if (!initialized)  init();

        String sql = null;
        logger.info("(1215) after init "  );

        boolean result = false;
        try {
            logger.info("(1215) before connect "  );
            
            sql = createSelectStmt();

            logger.info("(1217) SELECT stmt: " + sql );

            stmt = conn.createStatement();
            ResultSet resultset = stmt.executeQuery(sql);

            if ((result = resultset.next())) {
                logger.info("1140) .next " );
                if (this.bean instanceof Map) {
                    setSingleRowValues(resultset);
                    logger.info("Map " + this.bean);
                } else {
                    logger.info("1145) else " );
                    this.bean = setValues(resultset, this.bean);

                }
            }

            logger.info("1151) SELECT stmt: `" + sql + "`, result = " + result);
        } catch (Exception e) {
            logger.log(Level.WARNING, "1153)" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else
                throw new SQLException(e.getMessage());
        } finally {
            release();
        }
        return ans;
    }
    public Map selectByKeyForMap(String separateChar) throws SQLException {
        Map ans = new HashMap();
        if (!validConfig) {
            logger.config("1166) jLynx configuration invalid :: " + getEntity());
            throw new SQLException("jLynx configuration invalid");
        }

        if (!initialized)  init();

        String sql = null;
        logger.fine("(1263) init "  );

        boolean result = false;
        try {
            logger.fine("(1267) connect O"  );
            
            sql = createSelectStmt();

            logger.fine("1181) SELECT : " + sql );

            stmt = conn.createStatement();
            ResultSet resultset = stmt.executeQuery(sql);

            if ( resultset.next() ) {
                logger.fine("1187) .next " );
                setSingleRowValues(ans, resultset, separateChar);
                if ( resultset.next() ) {
                    throw new SQLException("too many data");
                }
            } else {
                ans = null;
            }

            logger.info("SELECT stmt: `" + sql + "`, result = " + result);
        } catch (Exception e) {
            logger.log(Level.WARNING, "1198)" + e.getMessage() + ", " + sql);
            if (e instanceof SQLException) {
                throw (SQLException) e;
            } else
                throw new SQLException(e.getMessage());
        } finally {
            release();
        }
        return ans;
    }
    private void setSingleRowValues(Map setTo, ResultSet rs, String separateChar) throws Exception {

        // assumes a single record
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); i++) {
            String key = entityName + separateChar + rs.getMetaData().getColumnName(i);
            setTo.put(key,
                      rs.getObject(i));
        }
    }

}// end class
