/*
 
 TopMind jLynx "jLynx JDBC Framework"
 Copyright (c) 2004-2006. TopMind Systems Inc.
 All rights reserved.
 
 This file is part of TopMind jLynx.
 
 TopMind jLynx is free software; you can redistribute it and/or modify
 it under the terms of the License. See website for License.
 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 */
package mod.sf.jlynx;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

/**
 * This interface defines essential methods needed to persist and retrieve POJOs
 * from relational databases systems (RDBMS); to create an instance use the
 * <code>RelationalFactory</code> class. As of v1.0 R3, <code>java.util.Map</code>
 * persistence is supported along with POJO persistence.<br>
 * <br>
 * The API currently supports / has been tested on the following databases:
 *
 * <ul>
 * <li>IBM DB2/UDB
 * <li>Microsoft SQL Server 2000
 * <li>Oracle 9i,10g
 * <li>MySQL
 * <li>HSQL
 * </ul>
 *
 * Subversion build $Revision: 68 $<br>
 * $Date: 2006-10-11 21:51:28 -0400 (Wed, 11 Oct 2006) $
 *
 */
public interface Relational extends Serializable {
    
    /**
     * Commit database transaction; by default jLynx will auto-commit.
     *
     * @since v1.0
     */
    void commit();
    
    /**
     * Deletes 1 row from a database. Usage:<br>
     * <br>
     * <code>RelationalFactory.getInstance(bean).delete();</code>
     * </p>
     *
     * @return boolean - Was the record deleted? Yes or No
     * @throws java.sql.SQLException
     * @since v1.0
       boolean ==> int ɕύX
     */
    int delete() throws java.sql.SQLException;
    
    /**
     * Execute PreparedStatement, see java.sql.PreparedStatement#execute()
     *
     * @return boolean
     * @throws SQLException
     * @since v1.0
     */
    public boolean execute() throws SQLException;
    
    
    
    /**
     * Execute PreparedStatement, see java.sql.PreparedStatement#executeQuery()
     *
     * @return List
     * @throws SQLException
     * @since v1.0
     */
    public List executeQuery() throws SQLException;
    
    /**
     * Get a PreparedStatement object using named query as a SQL statement.
     *
     * @return PreparedStatement object
     * @param namedQuery
     * @since v1.0
     *
     */
    public abstract PreparedStatement getPreparedStatement(String namedQuery)
    throws SQLException;
    
    /**
     * Inserts 1 row into a database. Usage:<br>
     * <br>
     * <code>Relational r =  RelationalFactory.getInstance(bean);<br>
     * r.insert();</code>
     * </p>
     *
     * @return int No. of rows inserted -- or -- ID of record inserted (MySQL
     *         and Microsoft SQL Server only)
     *
     * @throws java.sql.SQLException
     *
     * @since v1.0
     */
    int insert() throws java.sql.SQLException;
    
    /**
     * Rollback database transaction if autoCommit is off; by default, jLynx commits
     * all database transactions.
     *
     * @since v1.0
     */
    void rollback();
    
    /**
     * Saves POJO to database; equivalant to <code>update()</code> if record
     * exists or insert() if record does not exist. POJO is then updated with current
     * database values.
     *
     * @return int
     * @throws SQLException
     */
    int save() throws SQLException;
    
    /**
     * Whether nulls should be preserved in UPDATE and INSERT statements; by
     * default NULL property values are removed from the statement. Empty Strings
     * are treated as NULLs if set to true.
     *
     * @param keepNullsInQuery
     *            true (nulls are preserved) or false (default - nulls removed from SQL queries)
     *
     * @since v1.0
     */
    void saveNulls(boolean keepNullsInQuery);
    
    /**
     * Select the associated record from the database and populate the POJO's
     * values.
     *
     * Usage:<br>
     * <br>
     * <code>Relational r = RelationalFactory.getInstance(bean);<br>
     * r.select();
     * </code>
     * </p>
     *
     * @return boolean if records exists returns <code>true</code>
     * @throws java.sql.SQLException
     * @since v1.0
     */
    boolean select() throws java.sql.SQLException;
    
    /**
     * Set the connection auto_commit property; by default auto_commit is on
     * (true).
     *
     * @param b boolean
     * @since v1.0
     */
    void setAutoCommit(boolean b);
    
    /**
     * Set the entity to be used for CRUD operations when XML mapping is not present.
     *
     * @param entity
     *
     * @since v1.0 R3
     */
    void setEntity(String entity);
    
    /**
     * Set the underlying Java object, typically a POJO or Map.
     *
     * @param bean
     *
     * @since v1.0 R3
     */
    void setObject(Object bean);
    
    /**
     * <p>
     * Update 1 row in the database.
     * </p>
     *
     * <p>
     * Usage: create a Relational instance, like this:<br>
     * <br>
     * <code>Relational r = RelationalFactory.getInstance(bean);<br>
     * r.update();</code>
     * </p>
     *
     * @return int - No. of rows affected by the update (should return 1)
     * @throws java.sql.SQLException
     * @since v1.0
     */
    int update() throws java.sql.SQLException;
    
}