/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package mod.sf.jlynx;

import dwarf.hiberlike.HiberlikeException;
import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import dwarf.sql.MetaDataCache;
import java.sql.Connection;
import javax.sql.DataSource;
import java.util.logging.*;
/**
 *  implementation of the <tt>HibSessionFactory</tt> interface.
 */
public class JlynxSessionFactory implements HibSessionFactory {
    
    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.jlynx.JlynxSessionFactory");
    
    static final long serialVersionUID = 6820231656420970207L;
    
    private transient DataSource dataSource = null;
    
    transient Object metadataCache = null;
    
    /** RXgN^ */
    public JlynxSessionFactory() {
    }
    
    public void setMetaDataCache(Object obj) {

        log.info("#setMetadataCache ------ ܂ " + obj);
        if (obj == null) throw new NullPointerException();
        metadataCache = obj;
    }
    public void setDataSource(DataSource ds) {
        dataSource = ds;
    }
    
    public String toString() {
        
        return "JlynxSessionFactory[" + metadataCache + "]";
    }
    
    public HibSession getSession() throws HiberlikeException {
        JlynxHibSession ses = (JlynxHibSession) openSession();
        ses.setSeparateCharacter(".");
        return ses;
    }
    
    public HibSession getSession(Connection con) {
        JlynxHibSession ses = (JlynxHibSession) createSession(con);
        ses.setSeparateCharacter(".");
        return ses;
    }
    
    /** ʏ킱g */
    public HibSession openSession() throws HiberlikeException {
        
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        } catch (Exception ex) {
            throw new RuntimeException();
        }
        
        JlynxHibSession instance = new JlynxHibSession(connection);
        
        instance.setMetaDataCache(metadataCache);
        return instance;
    }
    
    /**
     *  Connection鎞ɁAConnection SessionB
     *  ŁAꂽHibSessioncloseȂǂB
     *  connectionŁAconnectionclosêǂ
     */
    public HibSession createSession(Connection con) {
        
        JlynxHibSession instance = new JlynxHibSession(con);
        
        return instance;
    }
    
}
