/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package mod.sf.jlynx;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HiberlikeException;
import dwarf.hiberlike.HibDuplicateKeyException;
import dwarf.hiberlike.HibNotNullConstraintException;
import dwarf.sql.HColumn;
import dwarf.sql.HColumnImpl;
import dwarf.sql.MetaData;
import dwarf.sql.MetaDataCache;
import dwarf.sql.Relation;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.*;
/**
 *  HibSession ̎
 */
public class JlynxHibSession implements HibSession {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.jlynx.JlynxHibSession");

  Connection conn = null;
  MetaDataCache mCache = null;

  /** RXgN^ */
  public JlynxHibSession(Connection con) {
    this.conn = con;
  }
  
  public void setMetaDataCache(Object newValue) {
    mCache = (MetaDataCache) newValue;
  }

  public void updateOrInsert(List list) {
    log.info("updateOrInsert --------------܂");
    
    try {
      update(list);
    } catch (HiberlikeException he) {
      insert(list);
    }
  }

  public int update(List list) {
    log.info("update --------------܂");

    HColumn col = (HColumn) list.get(0);
    RelationalEx jlynx = new RelationalEx(col.getTableName());
    jlynx.setConnection(conn);
    jlynx.setObject(list);
    jlynx.setKeyFields(getKeyFieldsArray(list));
    
    int n = 0;
    try {
      n = jlynx.update();
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    return n;
  }


  public int insert(List list) {
    log.info("insert --------------܂");

    HColumn col = (HColumn) list.get(0);
    RelationalEx jlynx = new RelationalEx(col.getTableName());
    jlynx.setConnection(conn);
    jlynx.setObject(list);
    
    int n = 0;
    try {
      n = jlynx.insert();
    } catch (Exception ex) {
      String msg = ex.getMessage();
      if (msg != null && msg.indexOf("duplicate key") >= 0) {
        throw new HibDuplicateKeyException("L[d", ex);
      } else {
        throw new HiberlikeException(ex);
      }
    }
    return n;
  }

  public void close() {
    //throw new UnsupportedOperationException();
    try {
      conn.close();
    } catch (Exception ex) {
      throw new RuntimeException();
    }
  }

  public List createListForNew(Map relation) {
    log.info("createListForNew --------------܂");

    Relation rel = (Relation) relation;
    
    MetaData metaData = getMetaData(rel);
    
    return metaData.toList();    // meta f[^Rs[āAListɂ
  }

  public MetaData getMetaData(Map relation) {
    
    if (mCache == null) throw new NullPointerException();
    
    String table1 = (String) relation.get("TABLE1");
    return mCache.getMetaData(/*dataSource,*/ table1);
  }

  //----------------------------------------------
  static final String SCHEMA = "schema01";

  public int delete(List list) {
    log.fine("delete --------------܂");
    
    HColumn col = (HColumn) list.get(0);
    RelationalEx jlynx = new RelationalEx(col.getTableName());
    jlynx.setConnection(conn);
    jlynx.setObject(list);
    jlynx.setKeyFields(getKeyFieldsArray(list));
    
    int n = 0;
    try {
      n = jlynx.delete();
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    return n;
  }

  /**
   *  ̒ŁAisPrimaryKey() == true ̍ږ𕶎̔zɂ
   */
  public String[] getKeyFieldsArray(List listOfColumn) {

    ArrayList list = new ArrayList();
    for (int i = 0; i < listOfColumn.size(); i++) {
      HColumn col = (HColumn) listOfColumn.get(i);
      if (col.isPrimaryKey()) {
        list.add(col.getColumnName());
      }
    }
    if (list.size() == 0) throw new HiberlikeException("L[܂");
    String[] ans = new String[list.size()];
    for (int j = 0; j < list.size(); j++) {
      ans[j] = (String) list.get(j);
    }
    return ans;
  }
  
  
  public List selectByKey(Map relation, List keyValues) {
    log.fine("selectByKey --------------܂");

    HColumn col = (HColumn) keyValues.get(0);
    RelationalEx jlynx = new RelationalEx(col.getTableName());
    jlynx.setConnection(conn);
    jlynx.setObject(keyValues);
    jlynx.setKeyFields(getKeyFieldsArray(keyValues));
    
    List list = null;
    try {
      list = jlynx.selectByKey();
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    
    return list;
  }

  public static HColumn createColumn2(String schemaName, String tableName, 
                                    String columnName, boolean primaryKey,
                                    int columnSize, String htmlInputTagName,
                                    int dataType, boolean nullable,
                                      Object value) {
    HColumnImpl col = new HColumnImpl();
    col.setSchemaName(schemaName);
    col.setTableName(tableName);
    col.setColumnName(columnName);
    col.setPrimaryKey(primaryKey);
    col.setColumnSize(columnSize);
    col.setHtmlInputTagName(htmlInputTagName);
    col.setDataType(dataType);
    col.setNullable(nullable);
    col.setValue(value);
    
    return col;
  }
  
  public void setValue(List list, int i, Object obj) {
    HColumn col = (HColumn) list.get(i);
    col.setValue(obj);
  }


  public List createListForEdit(Map relation, Map requestMap) {
    throw new UnsupportedOperationException();
  }

  public Object[] dbaShowList(Map relation, Map parameter) {
    throw new UnsupportedOperationException();
  }
  //-----------------------------------------------------------------------

  String separateChar = "_";

  public void setSeparateCharacter(String val) {
    separateChar = val;
  }

  private Object getFirstKey(Map ht) {

    Iterator it = ht.keySet().iterator();
    
    String key = null;
    if (it.hasNext()) {
      key = (String) it.next();
    }
    return key;
  }
  /** _ O\ƂĎo */
  public String toTableName(String tbl_col) {
    int n = tbl_col.indexOf(separateChar);
    if (n < 0) throw new IllegalArgumentException("'" + tbl_col + "'");
    return tbl_col.substring(0, n);
  }
  private Map removeTableName(Map ht) {

    Iterator it = ht.keySet().iterator();
    
    LinkedHashMap wk = new LinkedHashMap();//2007.6.24
    while (it.hasNext()) {
      String key = (String) it.next();
      Object val = ht.get(key);
      int n = key.indexOf(separateChar);
      if (n < 0) throw new IllegalArgumentException("'" + key + "'");
      key = key.substring(n + 1);
      wk.put(key, val);
    }
    return wk;
  }

  public int insert(Map object) {

    log.fine("insert(Map x) --------------܂");

    Object first = getFirstKey(object);
    String tbl_col = (String) first;
    String tblName = toTableName(tbl_col);
    RelationalEx jlynx = new RelationalEx(tblName);
    jlynx.setConnection(conn);
    jlynx.setObject(removeTableName(object));
    
    int n = 0;
    try {
      n = jlynx.insert();
    } catch (Exception ex) {
      String msg = ex.getMessage();
      //  postgresjdbchCoԂʂExceptionɕϊ
      if (msg != null && msg.indexOf("duplicate key") >= 0) {
        throw new HibDuplicateKeyException("L[d", ex);
      } else if (msg != null && msg.indexOf("violates not-null constraint") >= 0) {
        throw new HibNotNullConstraintException("not null ", ex);
      } else {
        throw new HiberlikeException(ex);
      }
    }
    return n;
  }

  public String[] getKeyFieldsArrayFromMetaDataCache(String tblName) {

    log.fine("^f[^܂");
    MetaData meta = mCache.getMetaData( tblName);
    return meta.getKeyList();
  }
  
  
  public int update(Map object) {
    log.fine("update(Map x) --------------܂");

    Object first = getFirstKey(object);
    String tbl_col = (String) first;
    String tblName = toTableName(tbl_col);
    RelationalEx jlynx = new RelationalEx(tblName);
    jlynx.setConnection(conn);
    jlynx.setObject(removeTableName(object));
    
    jlynx.setKeyFields(getKeyFieldsArrayFromMetaDataCache(tblName));
    
    int n = 0;
    try {
      n = jlynx.update();
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    return n;
  }

  public void updateOrInsert(Map object) {
    log.fine("updateOrInsert(Map x) --------------܂");

    Object first = getFirstKey(object);
    String tbl_col = (String) first;
    String tblName = toTableName(tbl_col);
    RelationalEx jlynx = new RelationalEx(tblName);
    jlynx.setConnection(conn);
    jlynx.setObject(removeTableName(object));
    
    jlynx.setKeyFields(getKeyFieldsArrayFromMetaDataCache(tblName));
    
    int n = 0;
    try {
      try {
        n = jlynx.update();
      } catch (Exception ex) {
      }

      if (n == 0) n = jlynx.insert();
      
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
  }

  
  public int delete(Map object) {
    log.fine("delete(Map x) --------------܂");

    Object first = getFirstKey(object);
    String tbl_col = (String) first;
    String tblName = toTableName(tbl_col);
    RelationalEx jlynx = new RelationalEx(tblName);
    jlynx.setConnection(conn);
    jlynx.setObject(removeTableName(object));
    
    jlynx.setKeyFields(getKeyFieldsArrayFromMetaDataCache(tblName));
    
    int n = 0;
    try {
      n = jlynx.delete();
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    return n;
  }
  public Map selectByKey(Map  keyValues) {
    log.fine("selectByKey(Map x) --------------܂");

    Object first = getFirstKey(keyValues);
    String tbl_col = (String) first;

    String tblName = toTableName(tbl_col);
    log.config("366) tblName = '" + tblName + "'");
    RelationalEx jlynx = new RelationalEx(tblName);
    jlynx.setConnection(conn);
    jlynx.setObject(removeTableName(keyValues));

    String[] keyFields = getKeyFieldsArrayFromMetaDataCache( tblName);
    log.config("372) keyFields = " + keyFields + "");
    if (keyFields == null) throw new HiberlikeException("null");
    if (keyFields.length == 0) throw new HiberlikeException("no key");
    jlynx.setKeyFields(keyFields);
    
    Map n = null;
    try {
      n = jlynx.selectByKeyForMap(separateChar);
    } catch (Exception ex) {
      throw new HiberlikeException(ex);
    }
    return n;
  }  
}
