/*
 
 TopMind jLynx "jLynx JDBC Framework"
 Copyright (c) 2004-2006. TopMind Systems Inc.
 All rights reserved.
 
 This file is part of TopMind jLynx.
 
 TopMind jLynx is free software; you can redistribute it and/or modify
 it under the terms of the License. See website for License.
 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 */
package mod.sf.jlynx;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Bean utils used by jLynx. Replaced use of Jakarta Commons BeanUtils as of
 * v1.1<br>
 * <br>
 * $Revision: 72 $<br>
 * $Date: 2006-11-13 09:54:44 -0500 (Mon, 13 Nov 2006) $
 *
 */
public class BeanUtils {
    
    private static Map cache = new HashMap();
    
    static String decapitalize(String fieldName) {
        
        return Introspector.decapitalize(fieldName);
        
        // return target;
    }
    
    /**
     * This method performs in a case-sensitive manner
     *
     */
    public static Map describe(Object target) {
        
        Map retMap = new HashMap();
        List retList = new LinkedList();
        Method[] methods = (Method[]) cache.get(target.getClass());
        if (methods == null) {
            methods = target.getClass().getMethods();
            cache.put(target.getClass(), methods);
        }
        
        for (int i = 0; i < methods.length; i++) {
            
            String method = methods[i].getName();
            if (method.indexOf("set") == 0 || method.indexOf("get") == 0) {
                retList.add(method.substring(3, method.length()));
            } else if(method.indexOf("is") == 0) {//added this in v1.2.1
                retList.add(method.substring(2, method.length()));
            }
            
            
        }
        
        Collections.sort(retList);
        Object[] props = retList.toArray();
        retList.clear();
        for (int i = 0; i < props.length - 1; i++) {
            
            if (props[i].equals(props[i + 1])) {
                String prop = decapitalize(props[i].toString());
                retMap.put(prop, getValue(prop, target));
            }
            
        }
        retList = null;
        return retMap;
        
    }
    
    public static Class getType(String property, Object target) {
        
        Class ret = Object.class;
        property = "set" + property;
        
        Method[] methods = (Method[]) cache.get(target.getClass());
        if (methods == null) {
            methods = target.getClass().getMethods();
            cache.put(target.getClass(), methods);
        }
        
        for (int i = 0; i < methods.length; i++) {
            
            if (property.equalsIgnoreCase(methods[i].getName())) {
                
                Class[] paramClass = methods[i].getParameterTypes();
                if (paramClass.length == 1) {
                    return paramClass[0];
                }
                
            }
            
        }
        
        return ret;
        
    }
    
    /**
     * This method performs in a case-insensitive manner
     *
     */
    public static Object getValue(String property, Object target) {
        
        String get = "get" + property;
        String is = "is" + property;
        
        Method[] methods = (Method[]) cache.get(target.getClass());
        if (methods == null) {
            methods = target.getClass().getMethods();
            cache.put(target.getClass(), methods);
        }
        
        for (int i = 0; i < methods.length; i++) {
            
            if (get.equalsIgnoreCase(methods[i].getName()) ||
                    is.equalsIgnoreCase(methods[i].getName())) {
                
                try {
                    return methods[i].invoke(target, (Object[])null);
                } catch (IllegalArgumentException ex) {
                    // ex.printStackTrace();
                } catch (IllegalAccessException ex) {
                    // ex.printStackTrace();
                } catch (InvocationTargetException ex) {
                    // ex.printStackTrace();
                }
                
            }
        }
        return null;
        
    }
    
    /**
     * This method performs in a case-insensitive manner
     *
     */
    public static void setValue(String property, Object target, Object value) {
        
        property = "set" + property;
        
        Method[] methods = (Method[]) cache.get(target.getClass());
        if (methods == null) {
            methods = target.getClass().getMethods();
            cache.put(target.getClass(), methods);
        }
        
        for (int i = 0; i < methods.length; i++) {
            
            if (property.equalsIgnoreCase(methods[i].getName())) {
                
                Class[] paramClass = methods[i].getParameterTypes();
                if (paramClass.length == 1) {
                    
                    try {
                        
                        methods[i].invoke(target, new Object[] { value });
                        
                    } catch (IllegalArgumentException ex) {
                        // ex.printStackTrace();
                    } catch (IllegalAccessException ex) {
                        // ex.printStackTrace();
                    } catch (InvocationTargetException ex) {
                        // ex.printStackTrace();
                    }
                    
                }
                
            }
        }
        
    }
    
    private BeanUtils() {
    }
    
}
