/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.webapp;

import dwarf.hiberlike.impl01.MetadataCacheImpl;
import dwarf.lru.DbmsDialectPostgres;
import dwarf.lru.SqlQueryCacheImpl;
import dwarf.lru.SqlQueryDaoFactoryImpl;
import dwarf.sqlex.Pg81DataSource;
import dwarf.ext.JlynxMultiSessionFactory;
import java.io.File;
import java.io.IOException;
import javax.servlet.*;
import javax.servlet.http.*;
import mod.sf.jlynx.JlynxSessionFactory;
import java.util.logging.*;
/**
 *  f[^x[X֌W̃IuWFNgAAvP[VReLXgɓo^T[ubg
 *  ݂̂Ƃ postgresɂΉĂȂB
 *  DataSouce ̕A΁Ãf[^x[Xɂڑł邩m܂B
 *
 *  @since 2006.11.05
 *         2007.01.04  Jsf@\
 *         2007.01.16  pbP[WύXXMLǂݍ
 *         2007.03.09  DataSourceZbgR[hBgetMap()Ή
 *         2007.06.24  strawberry-1.1 JpɏC
 */
public class MetadataServlet extends HttpServlet {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.MetadataServlet");

  static final long serialVersionUID = 8884406202783137848L;
  /**
   *  
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    ServletContext servletContext = getServletContext();
    String path = getServletContext().getRealPath("/");
    String contextName = getContextName(path);

    log.info("******** MetadataServlet::START '" + contextName + "'  ");

    // postgresɐڑ DataSource
    Pg81DataSource dataSource = new Pg81DataSource();
    dataSource.setProperties("jdbc:postgresql://192.168.115.90:5432/teststd",
                             "postgres",    // user
                             "postgres");   // pass

    try {
      // f[^x[X^f[^āALbVNX
      MetadataCacheImpl cache = new MetadataCacheImpl();
      cache.setDataSource(dataSource);
      servletContext.setAttribute("META_DATA_CACHE", cache);

      // Jlynx𗘗pȈORM p̃t@Ng
      JlynxSessionFactory fac = new JlynxSessionFactory();
      fac.setMetaDataCache(cache);
      fac.setDataSource(dataSource);
      servletContext.setAttribute("JLYNX_FACTORY", fac);

      // SQLČ^CvORM (?)
      SqlQueryDaoFactoryImpl daoFactory = new SqlQueryDaoFactoryImpl();
      daoFactory.setDataSource(dataSource);

      SqlQueryCacheImpl cacheImpl = new SqlQueryCacheImpl();
      cacheImpl.setSqlQueryDaoFactory(daoFactory);
      cacheImpl.setDbmsDialect(new DbmsDialectPostgres());
      servletContext.setAttribute("SQL_QUERY_CACHE", cacheImpl);


      // \ΉJlynx()
      JlynxMultiSessionFactory factory = new JlynxMultiSessionFactory();
      factory.setMetaDataCache(cache);
      fac.setDataSource(dataSource);
      servletContext.setAttribute("JLYNX_MULTI_SESSION_FACTORY", factory);

    } catch (Exception e) {
      log.log(Level.SEVERE, "60) catch Exception", e);
    }

    // -------------- init JSF ---------------

    log.info("************************************* MetadataServlet::END '" + contextName + "'");
  }



  public static String getContextName(String path) {
    //  :  path = /usr/local/jakarta-tomcat-3.2.4/webapps/dwarf/
    int n = path.lastIndexOf(File.separator);
    String wk = path.substring(0, n);
    int k = wk.lastIndexOf(File.separator);
    path = wk.substring(k + 1);
    // :   path = dwarf
    return path;
  }


  /**
   * doGet() \bh
   */
  protected final void doGet(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
  }
  protected final void doPost(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
  }
}
