/*
 * Copyright (C) 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.ext;

import java.util.*;
/**
 * Created on 2007/06/04, 
 */
public class MultipleTableSupport {
  

  public Map processTables(Map ht) {

    Map tables = new LinkedHashMap();
    
    Iterator it = ht.keySet().iterator();
    
    HashMap wk = new HashMap();
    while (it.hasNext()) {
      String tbl_col = (String) it.next();
      Object val = ht.get(tbl_col);
      int n = tbl_col.indexOf(".");
      if (n < 0) throw new IllegalArgumentException("'" + tbl_col + "'");

      // . O\ƂĎo 
      String tbl =  tbl_col.substring(0, n);
      String col = tbl_col.substring(n + 1);
      
      if (tables.get(tbl) == null) {
        tables.put(tbl, new LinkedHashMap());
      }
      
      Map aTable = (Map) tables.get(tbl);
      
      aTable.put(col, val);
    } 
    return tables;
  }
  
  
}
