/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlmock;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.*;
/**
 * Created on 2006/02/13
 */
public class MockStatement implements Statement  {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.sql");
  
  int type = 0;
  MockConnection connection = null;
  PreparedStatement ps = null;
  ResultSet rs = null;

  final int MAX_COLUMNS = 5;

  public MockStatement() {
  }
  public MockStatement(Connection con) {
    if (con instanceof MockConnection)  this.connection = (MockConnection)con;
  }
  /**
   * Creates a new instance of PreparedStatementProxy
   */
  public MockStatement(Connection con, PreparedStatement ps, ResultSet rs) {
    if (con instanceof MockConnection)  this.connection = (MockConnection)con;
    this.ps = ps;
    this.rs = rs;
  }

  
  //--------------------------------------------- IuWFNg
//  Object lastSetObject = "not setString";

  /** Statement ̎ */
  public void addBatch(String sql) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void cancel() throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void clearBatch() throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ 
  public void clearParameters() throws SQLException {
    throw new UnsupportedOperationException();
  }*/

  /** Statement ̎ */
  public void clearWarnings() throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void close() throws SQLException {
    log.info("close ****");
  }

  /** Statement ̎ */
  public boolean execute(String sql) throws SQLException {
    return ps.execute(sql);
  }

  /** Statement ̎ */
  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":execute(2)", sql);
    return ps.execute( sql, autoGeneratedKeys);
  }

  /** Statement ̎ */
  public boolean execute(String sql, String[] columnNames) throws SQLException {
    //config.traceSQL("PreparedStatementProxy:" + hashCode() + ":execute(3)", sql);
    return ps.execute( sql,  columnNames);
  }

  /** Statement ̎ */
  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    return ps.execute(sql,  columnIndexes);
  }

  /** Statement ̎ */
  public int[] executeBatch() throws SQLException {
    return ps.executeBatch();
  }


  public List getData1() {
      ArrayList list = new ArrayList();
      ArrayList row1 = new ArrayList();
      row1.add("aaa");
      row1.add("bbb");
      row1.add("123");
      list.add(row1);
      return list;
  }

  
  /** Statement ̎ */
  public ResultSet executeQuery(String sql) throws SQLException {
    log.info("240) sql = " + sql);

    connection.addTestCalls(sql);
    
    if ("select * from TBL1".equals(sql)) {
        List list1 = getData1();
      return new MockResultSetList(list1);
    } else if ("SELECT * FROM tbl1 WHERE aaa='2006-1-3'".equals(sql)) {
        List list1 = getData1();
      return new MockResultSetList(list1);
    }
    throw new UnsupportedOperationException(sql);
  }



  
  /** Statement ̎ */
  public int executeUpdate(String sql) throws SQLException {
    log.info("executeUpdate:***************" + sql);
    
    // MockConnectionɋL^
    connection.executeUpdate(sql);
    return 1;
  }

  /** Statement ̎ */
  public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public Connection getConnection() throws SQLException {
    return connection;
  }

  /** Statement ̎ */
  public int getFetchDirection() throws SQLException {
    return ps.getFetchDirection();
  }

  /** Statement ̎ */
  public int getFetchSize() throws SQLException {
    return ps.getFetchSize();
  }

  /** Statement ̎ */
  public ResultSet getGeneratedKeys() throws SQLException {
    return ps.getGeneratedKeys() ;
  }

  /** Statement ̎ */
  public int getMaxFieldSize() throws SQLException {
    return ps.getMaxFieldSize();
  }

  /** Statement ̎ */
  public int getMaxRows() throws SQLException {
    return ps.getMaxRows();
  }
  /** Statement ̎ */
  public boolean getMoreResults() throws SQLException {
    return ps.getMoreResults();
  }

  /** Statement ̎ */
  public boolean getMoreResults(int current) throws SQLException {
    return ps.getMoreResults(current);
  }

  public ParameterMetaData getParameterMetaData() throws SQLException {
    return ps.getParameterMetaData();
  }

  /** Statement ̎ */
  public int getQueryTimeout() throws SQLException {
    return ps.getQueryTimeout();
  }

  /** Statement ̎ */
  public ResultSet getResultSet() throws SQLException {
    return ps.getResultSet();
  }

  /** Statement ̎ */
  public int getResultSetConcurrency() throws SQLException {
    return ps.getResultSetConcurrency();
  }

  /** Statement ̎ */
  public int getResultSetHoldability() throws SQLException {
    return ps. getResultSetHoldability();
  }

  /** Statement ̎ */
  public int getResultSetType() throws SQLException {
    return ps.getResultSetType();
  }

  /** Statement ̎ */
  public int getUpdateCount() throws SQLException {
    return ps.getUpdateCount();
  }

  /** Statement ̎ */
  public SQLWarning getWarnings() throws SQLException {
    return ps. getWarnings();
  }

  public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setClob(int i, Clob x) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void setCursorName(String name) throws SQLException {
    ps.setCursorName(name);
  }


  public void setDate(int parameterIndex, java.sql.Date x, java.util.Calendar cal) throws SQLException {
    ps.setDate(parameterIndex, x, cal);
  }

  public void setDouble(int parameterIndex, double x) throws SQLException {
    ps.setDouble(parameterIndex, x);
  }

  /** Statement ̎ */
  public void setEscapeProcessing(boolean enable) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void setFetchDirection(int direction) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void setFetchSize(int rows) throws SQLException {
    throw new UnsupportedOperationException();
  }


  /** Statement ̎ */
  public void setMaxFieldSize(int max) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Statement ̎ */
  public void setMaxRows(int max) throws SQLException {
    throw new UnsupportedOperationException();
  }



  public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    ps.setObject(parameterIndex, x, targetSqlType);
  }

  public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
    ps.setObject(parameterIndex, x, targetSqlType, scale);
  }

  /** Statement ̎ */
  public void setQueryTimeout(int seconds) throws SQLException {
    throw new UnsupportedOperationException();
  }
}
