/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlmock;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;
/**
 *   f[^x[XɐڑɁAeXg邽߂̃bN
 * Created on 2006/02/12
 */
public class MockConnection implements Connection {

  static final String DELIMITER = "!";

  StringBuffer sb = new StringBuffer();
  Connection con = null;

  /** RXgN^ */
  public MockConnection() {
  }
  /** RXgN^ */
  public MockConnection(PreparedStatement ps) {
    this.ps = ps;
  }
  /**
   *  ĂяoꂽjdbcR}h𕶎ŎoB
   */
  public String getTestCalls() {
    return sb.toString();
  }
  
  public void addTestCalls(String msg) {
    sb.append(msg);
    sb.append(DELIMITER);
  }
  //-------------------------------------------

  ArrayList executeUpdate_list = new ArrayList();

  /** ̃\bh StatementĂ΂āAStatementɓnꂽ
    L */
  public int executeUpdate(String sql) throws SQLException {

    executeUpdate_list.add(sql);

    sb.append(sql);
    sb.append(DELIMITER);
    return 1;
  }

  public List getExecuteUpdateList() {
    return executeUpdate_list;
  }

  //-------------------------------------------

  boolean closedFlag = false;

  /** Connection̎ */
  public void close() throws SQLException {
    
    closedFlag = true;
    //    log.info("connection " + con.hashCode() + "  close ܂");
    sb.append("close()");
    sb.append(DELIMITER);
    
  }

  //----------------------------------------------------------------------
  /** Connection̎ */
  public void commit() throws SQLException {
    if (commitCalled) throw new IllegalStateException();
    commitCalled = true;
    sb.append("commit()");
    sb.append(DELIMITER);
  }

  boolean commitCalled = false;

  public boolean isCommitCalled() {
    return commitCalled;
  }

  //----------------------------------------------------------------------
  boolean rollbackCalled = false;

  public void rollback() throws SQLException {
    if (rollbackCalled) throw new IllegalStateException();
    rollbackCalled = true;
    sb.append("rollback()");
    sb.append(DELIMITER);
  }

  public boolean isRollbackCalled() {
    return rollbackCalled;
  }

  //----------------------------------------------------------------------

  Boolean autoCommitArg = null;

  public void setAutoCommit(boolean autoCommit) throws SQLException {
    autoCommitArg = new Boolean(autoCommit);
    sb.append("setAutoCommit(" + autoCommit + ")");
    sb.append(DELIMITER);
  }

  public Boolean getSetAutoCommitArg() {
    return autoCommitArg;
  }
  //----------------------------------------------------------------------

  /** Connection̎ */
  public Statement createStatement() throws SQLException {
    Statement st = new MockStatement(this);
    return st;
  }

  //----------------------------------------------------------------------
  
  MockDatabaseMetaData metaData = new MockDatabaseMetaData();

  /** Connection̎ */
  public DatabaseMetaData getMetaData() throws SQLException {
    return metaData;
  }

  /** Connection̎ */
  public boolean isClosed() throws SQLException {
    return closedFlag;
  }
  PreparedStatement ps = null;

  /** Connection̎ */
  public PreparedStatement prepareStatement(String sql) throws SQLException {
    return  ps;
  }

  public PreparedStatement getPreparedStatement() {
    return  ps;
  }



  /** Connection̎ */
  public void clearWarnings() throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Connection̎ */
  public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
    throw new UnsupportedOperationException();
  }

  /** Connection̎ */
  public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public boolean getAutoCommit() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public String getCatalog() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int getHoldability() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public int getTransactionIsolation() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public java.util.Map getTypeMap() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public SQLWarning getWarnings() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public boolean isReadOnly() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public String nativeSQL(String sql) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public CallableStatement prepareCall(String sql) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void rollback(Savepoint savepoint) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setCatalog(String catalog) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setHoldability(int holdability) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setReadOnly(boolean readOnly) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Savepoint setSavepoint() throws SQLException {
    throw new UnsupportedOperationException();
  }

  public Savepoint setSavepoint(String name) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setTransactionIsolation(int level) throws SQLException {
    throw new UnsupportedOperationException();
  }

  public void setTypeMap(java.util.Map map) throws SQLException {
    throw new UnsupportedOperationException();
  }
}
