/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import java.util.logging.*;
/**
 *  Postgresւ̐ڑpNX
 *  ݒ nb6config.properties ɋLq
 *  ́ASessionFactory AvP[VReLXgɓo^T[ubgĂ΂
 */
public class PgDataSource implements DataSource, DataSourceProperties {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.connection");

  public PgDataSource() {
  }

  String _url = null;
  String _userid;
  String _pass;

  public PgDataSource(String url, String userid, String pass) {
    this._url = url;
    this._userid = userid;
    this._pass = pass;
  }

  public void setProperties(String url, String userid, String pass) {
    _url = url;
    _userid = userid;
    _pass = pass;
  }

/*  
  public ResourceBundle getResourceBundle() {
    
    log.trace("PgDataSource::getResourceBundle -- ENTER");
    ResourceBundle resBundle = null;
    try {
      resBundle = ResourceBundle.getBundle(Constants.RESOURCE_FILE, Locale.JAPAN);
    } catch (Exception ex) {
      log.fatal(ex.getMessage() + ",  ...  " + Constants.RESOURCE_FILE + ".properties ܂");
    }
    return resBundle;
  }
*/
  boolean callSJIS = true;

  //---------------------------------------------------------

  static final String prefix = "dwarf." + "jdbc.";

  public Connection postgresGetConnection() throws SQLException {

    log.finer("PgDataSource::postgresGetConnection ----- ENTER");
/*
    ResourceBundle resource  = null;
    if (_url == null) {
      resource  = getResourceBundle();
    }
    */
    Connection connection = null;
    try {
      //String  driver   = resource.getString(prefix + "driver");
      // JDBChCõ[h
      Class.forName("org.postgresql.Driver");

      String  url      = (_url != null) ? _url : null; //resource.getString(prefix + "url");
      String  user     = (_userid != null) ? _userid : null; //resource.getString(prefix + "user");
      String  password = (_pass != null) ? _pass : null; //resource.getString(prefix + "password");
      
      // JDBC ڑ URL \
      log.info("connect to " + url);

      // Connection擾
      connection = DriverManager.getConnection(url, user, password);


      if (callSJIS) {
        // postgres ̏ꍇ CLIENT_ENCODING  'SJIS' ɂ
        String sql = "SET client_encoding TO '" + DB_CLIENT_ENCODING + "'";
        Statement st = connection.createStatement();
        try {
          st.execute(sql);
        } finally {
          st.close();
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
      throw new SQLException(e.getMessage());
    }
    log.info("Connection's hash = " + connection.hashCode());
    return new ConnectionProxy(connection);
  }  
  
  // PostgreSQLclient encoding
  public static final String DB_CLIENT_ENCODING = "SJIS";


  public void printStackTop(Exception e) {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    try {
      e.printStackTrace(pw);
    } finally {
      pw.close();
    }

    StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
    int i = 1;
    while (st.hasMoreTokens()) {
      String wk = st.nextToken();
      i++;
      if (5 <= i && i <= 7) {
        System.out.println("# " + wk);
      } else if (7 < i) {
        break;
      }
    }
    
  }


  // -------------------------------------------------------- implements of DataSource
  
  public synchronized Connection getConnection() throws SQLException {
    return postgresGetConnection();
  }

  public Connection getConnection(String a, String b) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public PrintWriter getLogWriter() throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public int getLoginTimeout() throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public void setLogWriter(PrintWriter printWriter) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public void setLoginTimeout(int param) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
}
