/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sqlex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import java.util.logging.*;
/**
 *  MySQLւ̐ڑpNX
 */
public class MySQLDataSource implements DataSource  {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.connection");

  //---------------------------------------------------------

  static final String prefix = "dwarf." + "jdbc.";

  public Connection postgresGetConnection() throws SQLException {

    log.finer("MySQLDataSource::postgresGetConnection ----- ENTER");

    
    Connection connection = null;
    try {
      // JDBChCõ[h
      Class.forName("org.gjt.mm.mysql.Driver"); // MySQL̏ꍇ

      String url = "jdbc:mysql://192.168.19.80/mysql";

      // JDBC ڑ URL \
      log.info("             connect to " + url);

      // Connection擾
      connection = DriverManager.getConnection(url, "root", "");

    } catch (Exception e) {
      e.printStackTrace();
      throw new SQLException(e.getMessage());
    }
    return connection;
  }  
  
  // PostgreSQLclient encoding
  public static final String DB_CLIENT_ENCODING = "SJIS";


  public void printStackTop(Exception e) {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    try {
      e.printStackTrace(pw);
    } finally {
      pw.close();
    }

    StringTokenizer st = new StringTokenizer(sw.toString(), "\n");
    int i = 1;
    while (st.hasMoreTokens()) {
      String wk = st.nextToken();
      i++;
      if (5 <= i && i <= 7) {
        System.out.println("# " + wk);
      } else if (7 < i) {
        break;
      }
    }
    
  }


  // -------------------------------------------------------- implements of DataSource
  
  public synchronized Connection getConnection() throws SQLException {
    return postgresGetConnection();
  }

  public Connection getConnection(String a, String b) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public PrintWriter getLogWriter() throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public int getLoginTimeout() throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public void setLogWriter(PrintWriter printWriter) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
  public void setLoginTimeout(int param) throws SQLException {
    throw new UnsupportedOperationException();
  }
  
}
