/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sql;

import java.io.Serializable;
import java.sql.Types;
import java.text.MessageFormat;
import java.math.BigDecimal;
/**
 *  f[^x[X̍ڂ̏ێNX<br>
 *  2006.07.30 schemaName ǉ
 *  2006.11.04 setValueSerializable`FbNǉ
 *  2006.11.17 nullablebooleanɕύX
 */
public class HColumnImpl implements Serializable, HColumn {

  static final long serialVersionUID = -4771072577621036412L;
  
  protected String   schemaName = null;        // 0
  protected String   tableName = null;         // 1
  protected boolean  primaryKey  = false;
  protected String   columnName   = null;      // 2
  protected int      columnSize   = 0;
  protected String   htmlInputTagName    = ""; // 3
  protected int      dataType = 0;
  protected boolean  nullable = false;

  // i[ꂽl SerializablełȂ肤

  protected Object   value       = null;       // 4

  /** RXgN^ */
  public HColumnImpl() {
  }
  /** RXgN^ */
  public HColumnImpl(String s, String t, boolean p, String c) {
    this.schemaName = s;
    this.tableName = t;
    this.primaryKey = p;
    this.columnName = c;

  }
  
  /** Rs[ */
  public Object clone() {
    HColumnImpl newCol       = new HColumnImpl();
    newCol.schemaName       = this.schemaName;
    newCol.tableName        = this.tableName;
    newCol.primaryKey       = this.primaryKey;
    newCol.columnName       = this.columnName;
    newCol.columnSize       = this.columnSize;
    newCol.htmlInputTagName = this.htmlInputTagName;
    newCol.dataType         = this.dataType;
    newCol.nullable         = this.nullable;
    newCol.value            = this.value;
    return newCol;
  }

  final void copyFields(HColumnImpl newCol, HColumnImpl from) {
    newCol.schemaName       = from.schemaName;
    newCol.tableName        = from.tableName;
    newCol.primaryKey       = from.primaryKey;
    newCol.columnName       = from.columnName;
    newCol.columnSize       = from.columnSize;
    newCol.htmlInputTagName = from.htmlInputTagName;
    newCol.dataType         = from.dataType;
    newCol.nullable         = from.nullable;
    newCol.value            = from.value;
  }


  public String getSchemaName() {   return schemaName;   }
  public void setSchemaName(String name) {   schemaName = name;   }
  
  public String getTableName() {    return tableName;  }
  public void setTableName(String name) {    tableName = name;  }
  
  public boolean isPrimaryKey() {    return primaryKey;  }
  public void setPrimaryKey(boolean b) {    primaryKey = b;  }

  public String getColumnName() {    return columnName;  }
  public void setColumnName(String name) {    columnName = name;  }

  public int getColumnSize() {    return columnSize;  }
  public void setColumnSize(int newValue) {    columnSize = newValue;  }

  public String getHtmlInputTagName() {    return htmlInputTagName;  }

  public int getDataType() {    return dataType;  }
  public void setDataType(int newValue) {    dataType = newValue;  }

  /** true̎Anull */
  public boolean isNullable() { return nullable; }
  public void setNullable(boolean n) {  nullable = n;  }

  public Object getValue() {    return value;  }
  public void setValue(Object newValue) {

    if (newValue == null) {
      value = newValue;
    } else if (newValue instanceof Serializable) {
      value = newValue;
    } else {
      value = newValue;
      System.out.println("not Serializable " + newValue.getClass().getName() + " !!!");
      //throw new IllegalArgumentException("can't set value, not Serializable");
    }
  }

  
  /** value 𕶎ɂĕԂ */
  public String getColumnValue() {
    if (value == null) return null;
    return value.toString();
  }


  public String format(String pattern) {
    Object[] args = new Object[] {
      schemaName,       // 0
      tableName,        // 1
      columnName,       // 2
      htmlInputTagName, // 3
      value,            // 4
      new Boolean(primaryKey), // 5
      new Integer(columnSize), // 6
      new Integer(dataType),   // 7
      /*ColumnTypes.*/ getTypeName(dataType), // 8
      new Boolean(nullable),    // 9
    };

    return MessageFormat.format(pattern, args);
  }
  
  public String toString() {
    return "Column[" + htmlInputTagName + " " + tableName + "." + columnName +
           ", dataType = " + 
              /*ColumnTypes.*/ getTypeName(dataType) +
           ", value = " + getColumnValue()
                
     +  "]";
  }

  // ------------------------------------------------------------


  public void setHtmlInputTagName(String newValue) {    htmlInputTagName = newValue;  }
  
  public void determineHtmlInputTagName(int newValue) {
    htmlInputTagName = "f" + newValue;
  }



  public String getTypeName(int type) {
    String ans = "";

    switch (type) {
    case Types.CHAR:
      ans = "CHAR";
      break;

    case Types.VARCHAR:
      ans = "VARCHAR";
      break;

    case Types.DATE:
      ans = "DATE";
      break;
      
    case Types.BIT:
      ans = "BIT";
      break;

    case Types.INTEGER:
      ans = "INTEGER";
      break;

    case Types.LONGVARCHAR:
      ans = "LONGVARCHAR";
      break;
      
    case Types.NUMERIC:
      ans = "NUMERIC";
      break;

    case Types.DECIMAL:
      ans = "DECIMAL";
      break;
      
    case Types.DOUBLE:
      ans = "DOUBLE";
      break;

    case Types.TIME:
      ans = "TIME";
      break;
      
    case Types.TIMESTAMP:
      ans = "TIMESTAMP";
      break;

    case Types.OTHER:
      ans = "OTHER";
      break;

    default:
      ans = "s" + type;
    }
    return ans;
  }
/*
 public static final int ARRAY 2003 
 public static final int BIGINT -5 
 public static final int BINARY -2 
 public static final int BIT -7 
 public static final int BLOB 2004 
 public static final int BOOLEAN 16 
 public static final int CHAR 1 
 public static final int CLOB 2005 
 public static final int DATALINK 70 
 public static final int DATE 91 
 public static final int DECIMAL 3 
 public static final int DISTINCT 2001 
 public static final int DOUBLE 8 
 public static final int FLOAT 6 
 public static final int INTEGER 4 
 public static final int JAVA_OBJECT 2000 
 public static final int LONGVARBINARY -4 
 public static final int LONGVARCHAR -1 
 public static final int NULL 0 
 public static final int NUMERIC 2 
 public static final int OTHER 1111 
 public static final int REAL 7 
 public static final int REF 2006 
 public static final int SMALLINT 5 
 public static final int STRUCT 2002 
 public static final int TIME 92 
 public static final int TIMESTAMP 93 
 public static final int TINYINT -6 
 public static final int VARBINARY -3 
 public static final int VARCHAR 12 
*/

  Object defaultValue = null;

  public void setDefaultValue(Object newValue) {
    defaultValue = newValue;
  }

  public Object getDefaultValue() {

    if (defaultValue != null) return defaultValue;
    
    Object ans = "";
    switch (dataType) {
    case Types.INTEGER:
      ans = new Integer(0);
      break;
    case Types.NUMERIC:
      ans = new BigDecimal(0);
      break;
    case Types.DOUBLE:
      ans = new Double(0);
      break;
      
    }
    return ans;
  }


}
