/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.sql;

/**
 */
public interface HColumn {

  /**
   * Rs[ 
   */
  Object clone();

  void determineHtmlInputTagName(int newValue);

  String format(String pattern);

  String getColumnName();

  int getColumnSize();

  /**
   * value 𕶎ɂĕԂ 
   */
  String getColumnValue();

  int getDataType();

  String getHtmlInputTagName();

  String getSchemaName();

  String getTableName();

  String getTypeName(int type);

  Object getValue();

  /**
   * true̎Anull 
   */
  boolean isNullable();

  boolean isPrimaryKey();

  void setColumnName(String name);

  void setColumnSize(int newValue);

  void setDataType(int newValue);

  void setHtmlInputTagName(String newValue);

  void setNullable(boolean n);

  void setPrimaryKey(boolean b);

  void setSchemaName(String name);

  void setTableName(String name);

  void setValue(Object newValue);

  String toString();

  Object getDefaultValue();
}
