/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hiberlike.impl01;

import java.util.Map;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import dwarf.sql.MetaData;
import dwarf.sql.MetaDataCache;
import dwarf.sql.MetaDataCreator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.*;
/**
 *  MetaDatãLbV
 */
public class  MetadataCacheImpl implements MetaDataCache {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.metadata.CacheImpl");

  public static final int VERSION = 3;

  DataSource defaultDataSource = null;
  
  public void setDataSource(DataSource ds) {
    log.info("31) setDataSource ----------------------- " + ds + " ****");
    defaultDataSource = ds;
  }

  public Map getMap() {
    return new MetaDataCacheMap(defaultDataSource, hashtable);
  }
  //----------------------------------------------------------------------------
  
  Hashtable hashtable = new Hashtable();

  public String toString() {

    StringBuffer sb = new StringBuffer();
    sb.append("MetadataCacheImpl[defaultDataSource = ");
    if (defaultDataSource == null) {
      sb.append("null, ");
    } else {
      sb.append(defaultDataSource.toString());
      sb.append(", ");
    }

    Iterator it = hashtable.keySet().iterator();
    while (it.hasNext()) {
      Object key = it.next();
      sb.append(key.toString());
      sb.append(", ");
    }
    
    sb.append("]@");
    sb.append(Integer.toHexString(hashCode()));
    return sb.toString();
  }
  
  
  /** Jlynx̓ */
  public MetaData getMetaData( String tableName) {
    if (tableName == null) throw new NullPointerException("tableName");
    MetaData ans = null;
    try {
      Object obj = hashtable.get(tableName);
      if (obj != null) {
        log.fine(" 73) LbVɌ܂ use cached data ..... table name = " + tableName);
        ans = (MetaData) obj;
      } else {
        log.fine(" 77) defaultDataSourceg܂ ");
        Connection con = defaultDataSource.getConnection();
        if (con == null) throw new NullPointerException();
        try {
          log.fine(" 80)  read database meta data ..... table name = " + tableName);
          boolean toLower = false; //(dataSource instanceof TableNameUpperCase) ? true : false;
          ans = new MetaDataCreator().create(con, tableName, toLower);
          hashtable.put(tableName, ans);
        } finally {
          con.close();
        }
      }
    } catch (SQLException sqle) {
      throw new RuntimeException(sqle);
    }
    return ans;
  }
  
}
