/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hibermock;

import dwarf.sql.HColumnImpl;
import dwarf.sql.MetaData;
import dwarf.sql.MetaDataCache;
import dwarf.sql.MetaDataImpl;
import java.util.HashMap;
/**
 *  MetaDataCache ̃bN
 * Created on 2007/06/04, 
 */
public class MockMetaDataCache implements MetaDataCache {
  
  HashMap map = new HashMap();
  
  
  /** RXgN^
   
       @see dwarf.sql.TestDataFactory
   */
  public MockMetaDataCache() {
    // \P̎L[͍ڂP
    MetaDataImpl meta1 = new MetaDataImpl();
    meta1.add(new HColumnImpl("sc", "\P", true, "ڂP"));
    map.put("\P", meta1);

    // \Q̎L[͍ڂP
    MetaDataImpl meta2 = new MetaDataImpl();
    meta2.add(new HColumnImpl("sc", "\Q", true, "ڂP"));
    map.put("\Q", meta2);
  
    // \̎L[͍ڂP
    MetaDataImpl meta0 = new MetaDataImpl();
    meta0.add(new HColumnImpl("sc", "\", true, "ڂP"));
    map.put("\", meta0);

  
    // \̎L[͍ڂP
    MetaDataImpl meta3 = new MetaDataImpl();
    meta3.add(new HColumnImpl("sc", "TBL1", true, "aaa"));
    map.put("TBL1", meta3);
  }

  public MetaData getMetaData(String tableName) {
    return (MetaData) map.get(tableName);
  }
  
}
