/*
 * Copyright (C) 2006, 2007 Masahito Henmi, All rights reserved.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
package dwarf.hibermock;

import dwarf.hiberlike.HibSession;
import dwarf.hiberlike.HibSessionFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.*;
import javax.sql.DataSource;
/**
 * 
 */
public class MockHibSession01Factory implements HibSessionFactory {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("dwarf.hibermock");

  List listForNew = null;  // createListForNew \bhĂ΂ꂽƂɕԂListZbg
  List listForEdit = null;

  List listHeader = new ArrayList();
  List listOfList = new ArrayList();

  
  /** RXgN^ */
  public MockHibSession01Factory() {

    listForNew = TestDataFactory.getTestData01();
    listForEdit = TestDataFactory.getTestData02();

    listHeader = TestDataFactory.getTestData02();
    listOfList.add(listHeader);
  }

  MockHibSession session = null;

  
  int count = 0;
  
  public HibSession openSession() {
    
    session = new MockHibSession();
//    session.listForNew = this.listForNew;
    session.setCreateListForNew(this.listForNew);
    session.setListForEdit(listForEdit);

    count++;
    log.info(" openSession " + Integer.toHexString(session.hashCode()));

    session.setDbaShowList( listHeader,  listOfList);
    return session;
  }

  public MockHibSession getLastCreatedSession() {
    return session;
  }

  public int getCountOfOpenSessionCalled() {
    return count;
  }

  public HibSession createSession(Connection con) {
    return openSession();
  }

  public void setMetaDataCache(Object mc) {
    throw new UnsupportedOperationException();
  }

  public HibSession getSession(Connection connection) {
    throw new UnsupportedOperationException();
  }

  public HibSession getSession() {
    throw new UnsupportedOperationException();
  }

    public void setDataSource(DataSource ds) {
      throw new UnsupportedOperationException();
    }
  
}
