/*
 * Decompiled with CFR 0.152.
 */
package strawberry.viewsupport;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.EncodingHandler;
import com.sun.facelets.compiler.EndElementInstruction;
import com.sun.facelets.compiler.LiteralAttributeInstruction;
import com.sun.facelets.compiler.LiteralTextInstruction;
import com.sun.facelets.compiler.NamespaceHandler;
import com.sun.facelets.compiler.StartElementInstruction;
import com.sun.facelets.compiler.UIInstructionHandler;
import com.sun.facelets.impl.DefaultFacelet;
import com.sun.facelets.tag.CompositeFaceletHandler;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import strawberry.viewsupport.FaceletViewHandlerSupport;

public class FaceletViewHandlerSupportImpl
extends FaceletViewHandlerSupport {
    protected static final Logger log = Logger.getLogger("strawberry.fls.viewhandler");
    protected static final Logger stateRestoreLog = Logger.getLogger("strawberry.state.restore");
    private FaceletFactory faceletFactory;
    String contextDefaultSuffix = null;
    private String defaultSuffix;

    public FaceletViewHandlerSupportImpl() {
    }

    public FaceletViewHandlerSupportImpl(FaceletFactory xx) {
        this.faceletFactory = xx;
    }

    public boolean isSaveStatedView(FacesContext context) {
        Map rpMap = context.getExternalContext().getRequestParameterMap();
        return rpMap.get("com.sun.faces.VIEW") != null;
    }

    public UIViewRoot restoreView(String viewId, FacesContext context) {
        ViewHandler outerViewHandler = context.getApplication().getViewHandler();
        String renderKitId = outerViewHandler.calculateRenderKitId(context);
        UIViewRoot restoredView = new UIViewRoot();
        restoredView.setRenderKitId("HTML_BASIC");
        context.setViewRoot(restoredView);
        StateManager sm = context.getApplication().getStateManager();
        if (sm != null) {
            restoredView = sm.restoreView(context, viewId, renderKitId);
            restoredView.getAttributes().put("strawberry.restoredView", Boolean.TRUE);
        } else {
            stateRestoreLog.fine("65) --------------------StateManager \u304c null\u306a\u306e\u3067skip");
        }
        stateRestoreLog.fine("67) getChildren().size() = " + restoredView.getChildren().size());
        return restoredView;
    }

    public void buildView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("81 buildView XML\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059 '" + viewToRender.getViewId() + "'");
        }
        String renderedViewId = this.getRenderedViewId(context, viewToRender.getViewId());
        log.config("85) renderedViewId = '" + renderedViewId + "'");
        viewToRender.setViewId(renderedViewId);
        Facelet f = null;
        FaceletFactory.setInstance(this.faceletFactory);
        try {
            f = this.faceletFactory.getFacelet(renderedViewId);
        }
        catch (IOException ioe) {
            log.severe("92 buildView -------------------");
            throw ioe;
        }
        catch (FacesException fe) {
            log.severe("96 buildView -------------------");
            throw fe;
        }
        finally {
            FaceletFactory.setInstance(null);
        }
        log.fine("102  ##########################  f.apply \u306e\u524d");
        log.fine("103  f = " + f.getClass().getName());
        if (f instanceof DefaultFacelet) {
            this.printFaceletTree((DefaultFacelet)f);
        }
        try {
            f.apply(context, (UIComponent)viewToRender);
        }
        catch (IOException ioe) {
            log.fine("109 buildView ----------------------");
            ioe.printStackTrace();
            throw ioe;
        }
        catch (FacesException fe) {
            log.fine("113 buildView -------------------------");
            fe.printStackTrace();
            throw fe;
        }
        log.fine("117  ##########################  f.apply \u306e\u5f8c");
    }

    public void printFaceletTree(DefaultFacelet df) {
        FaceletHandler root = df.getRoot();
        if (root instanceof EncodingHandler) {
            this.printEncodingHandler((EncodingHandler)root);
        }
    }

    public void printEncodingHandler(EncodingHandler eh) {
        FaceletHandler next = eh.getNext();
        if (next instanceof CompositeFaceletHandler) {
            this.printCompositeFaceletHandler("", (CompositeFaceletHandler)next);
        }
    }

    public void printCompositeFaceletHandler(String spc, CompositeFaceletHandler ch) {
        log.fine("144) CompositeFaceletHandler = " + ch);
        FaceletHandler[] child = ch.getHandlers();
        for (int i = 0; i < child.length; ++i) {
            FaceletHandler kids = child[i];
            log.fine("153) " + spc + "[" + i + "] = " + kids.getClass().getName());
            if (kids instanceof NamespaceHandler) {
                this.printNamespaceHandler(spc, (NamespaceHandler)kids);
                continue;
            }
            if (!(kids instanceof UIInstructionHandler)) continue;
            this.printUIInstructionHandler(spc + "  ", (UIInstructionHandler)kids);
        }
    }

    public void printNamespaceHandler(String spc, NamespaceHandler nh) {
        FaceletHandler next = nh.getNext();
        log.fine("164) " + spc + "next = " + next.getClass().getName());
        if (next instanceof UIInstructionHandler) {
            this.printUIInstructionHandler(spc + "  ", (UIInstructionHandler)next);
        } else if (next instanceof CompositeFaceletHandler) {
            this.printCompositeFaceletHandler(spc + "  ", (CompositeFaceletHandler)next);
        }
    }

    public void printUIInstructionHandler(String spc, UIInstructionHandler uh) {
        Object[] child = uh.getInstructions();
        int startElement = 0;
        int literalAttribute = 0;
        int literalText = 0;
        int endElement = 0;
        for (int i = 0; i < child.length; ++i) {
            Object kids = child[i];
            if (kids instanceof StartElementInstruction) {
                ++startElement;
                continue;
            }
            if (kids instanceof LiteralAttributeInstruction) {
                ++literalAttribute;
                continue;
            }
            if (kids instanceof LiteralTextInstruction) {
                ++literalText;
                continue;
            }
            if (kids instanceof EndElementInstruction) {
                ++endElement;
                continue;
            }
            log.fine("193) " + spc + "(" + i + ") = " + kids.getClass().getName());
        }
        log.fine("198) " + spc + "statics = " + startElement + ", " + literalAttribute + ", " + literalText + ", " + endElement);
    }

    public String getRenderedViewId(FacesContext context, String actionId) {
        ExternalContext extCtx = context.getExternalContext();
        String viewId = actionId;
        if (extCtx.getRequestPathInfo() == null) {
            // empty if block
        }
        viewId = this.convertViewId(context, viewId);
        if (log.isLoggable(Level.FINER)) {
            log.finer("(145) ActionId -> ViewId: " + actionId + " -> " + viewId);
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertViewId(FacesContext context, String viewId) {
        FaceletViewHandlerSupportImpl faceletViewHandlerSupportImpl = this;
        synchronized (faceletViewHandlerSupportImpl) {
            if (this.contextDefaultSuffix == null) {
                this.contextDefaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                log.config("243) contextDefaultSuffix = '" + this.contextDefaultSuffix + "'");
                if (this.contextDefaultSuffix == null) {
                    this.contextDefaultSuffix = ".html";
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("contextDefaultSuffix " + this.contextDefaultSuffix);
                }
            }
        }
        String convertedViewId = viewId;
        if (!convertedViewId.endsWith(this.contextDefaultSuffix)) {
            StringBuffer buffer = new StringBuffer(convertedViewId);
            int extIdx = convertedViewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, convertedViewId.length(), this.contextDefaultSuffix);
            } else {
                buffer.append(this.contextDefaultSuffix);
            }
            convertedViewId = buffer.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("viewId after appending the context suffix " + convertedViewId);
            }
        }
        return convertedViewId;
    }

    public String getDefaultSuffix(FacesContext context) throws FacesException {
        if (this.defaultSuffix == null) {
            ExternalContext extCtx = context.getExternalContext();
            String viewSuffix = extCtx.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            this.defaultSuffix = viewSuffix != null ? viewSuffix : ".jsp";
        }
        return this.defaultSuffix;
    }
}

