/*
 * Decompiled with CFR 0.152.
 */
package strawberry.viewrenderer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import strawberry.viewrenderer.Sanitizer;

public class StringResponseWriter
extends ResponseWriter {
    protected static final Logger log = Logger.getLogger("strawberry.StringResponseWriter");
    Writer writer = new StringWriter();
    Sanitizer sanitizer = null;
    Hashtable notCloseHt = new Hashtable();
    boolean openFlag = false;
    String quote = "\"";
    Hashtable scriptHash = new Hashtable();

    public StringResponseWriter() {
        this.sanitizer = new Sanitizer();
        this.initHashtable();
    }

    public StringResponseWriter(Sanitizer sanitizer) {
        this.sanitizer = sanitizer;
        this.initHashtable();
    }

    private void initHashtable() {
        this.notCloseHt.put("input", "input");
    }

    public void closeIfNecessary() throws IOException {
        if (this.openFlag) {
            this.writer.write(">");
            this.openFlag = false;
        }
    }

    public void endElement(String name) throws IOException {
        log.finer("endElement");
        this.closeIfNecessary();
        if (this.notCloseHt.get(name) != null) {
            return;
        }
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">");
    }

    public void flush() throws IOException {
        this.closeIfNecessary();
        log.finer("flush");
    }

    public void startElement(String name, UIComponent component) throws IOException {
        log.finer("startElement");
        this.closeIfNecessary();
        this.writer.write("<");
        this.writer.write(name);
        this.openFlag = true;
    }

    public void write(String msg) throws IOException {
        this.closeIfNecessary();
        log.finer("write");
        this.writer.write(msg);
    }

    public void setQuoteCharacter(String qChar) {
        this.quote = qChar;
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        log.finer("writeAttribute");
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=");
        this.writer.write(this.quote);
        if (this.isJavaScriptAttribute(name)) {
            this.writer.write(value.toString());
        } else {
            this.writer.write(this.sanitizer.encode(value.toString()));
        }
        this.writer.write(this.quote);
    }

    public boolean isJavaScriptAttribute(String name) {
        return "onfocus".equalsIgnoreCase(name) || "onblur".equalsIgnoreCase(name);
    }

    public void writeText(Object text, String property) throws IOException {
        this.closeIfNecessary();
        log.finer("writeText");
        this.writer.write(this.sanitizer.encode(text.toString()));
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        log.finer("writeURIAttribute");
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        String url = this.sanitizer.encodeURL(value.toString());
        log.finer("url = " + url);
        this.writer.write(url);
        this.writer.write("\"");
    }

    public String toString() {
        String ans = null;
        if (this.writer instanceof StringWriter) {
            StringWriter sw = (StringWriter)this.writer;
            ans = sw.toString();
        }
        return ans;
    }

    public void writeJavaScript(String type, String msg) throws IOException {
        Writer wri = (Writer)this.scriptHash.get(type);
        if (wri == null) {
            wri = new StringWriter();
            this.scriptHash.put(type, wri);
        }
        wri.write(msg);
    }

    public String getScript(String type) {
        String ans = null;
        Writer scriptWriter = (Writer)this.scriptHash.get(type);
        if (scriptWriter != null && scriptWriter instanceof StringWriter) {
            StringWriter sw = (StringWriter)scriptWriter;
            ans = sw.toString();
        }
        return ans;
    }

    public void close() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("write " + off + ", " + len);
        }
        this.writer.write(cbuf, off, len);
    }

    public String getContentType() {
        return null;
    }

    public void writeComment(Object obj) throws IOException {
        String wk = null;
        wk = obj instanceof String ? (String)obj : obj.toString();
        this.writer.write("<!--");
        this.writer.write(wk);
        this.writer.write("-->");
    }

    public void startDocument() throws IOException {
    }

    public void writeText(char[] values, int param, int param2) throws IOException {
    }

    public String getCharacterEncoding() {
        return null;
    }
}

