/*
 * Decompiled with CFR 0.152.
 */
package strawberry.viewrenderer;

public class Sanitizer {
    public String encode(String in) {
        if (in == null) {
            return "";
        }
        int n = in.length();
        if (n == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&#39;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String encodeURL(String inner) {
        String wk = null;
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < inner.length(); ++i) {
                char ch = inner.charAt(i);
                if (ch == '\"') {
                    sb.append("%22");
                    continue;
                }
                if (' ' < ch && ch < '\u007f') {
                    sb.append(ch);
                    continue;
                }
                String wk1 = inner.substring(i, i + 1);
                byte[] ar = wk1.getBytes("MS932");
                if (ar.length > 1) {
                    sb.append("%" + this.toHex(ar[0]) + "%" + this.toHex(ar[1]));
                    continue;
                }
                sb.append("%" + this.toHex(ar[0]));
            }
            wk = sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException();
        }
        return wk;
    }

    private String toHex(int i) {
        String wk = Integer.toHexString(i &= 0xFF);
        switch (wk.length()) {
            case 1: {
                wk = "0" + wk;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return wk;
    }
}

