/*
 * Decompiled with CFR 0.152.
 */
package strawberry.viewhandler;

import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ViewHandlerImpl
extends ViewHandler {
    protected static final Logger log = Logger.getLogger("strawberry.vh");
    private static final String INVOCATION_PATH = "com.sun.faces.INVOCATION_PATH";
    private String contextDefaultSuffix;

    public ViewHandlerImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created ViewHandler instance ");
        }
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (null == context || null == viewToRender) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context + " viewToRender " + viewToRender;
            throw new NullPointerException(message);
        }
        String requestURI = viewToRender.getViewId();
        if (log.isLoggable(Level.FINE)) {
            log.fine("About to render view " + requestURI);
        }
        String mapping = this.getFacesMapping(context);
        String newViewId = requestURI;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found URL pattern mapping to FacesServlet " + mapping);
            }
            newViewId = this.convertViewId(context, requestURI);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Found no URL patterns mapping to FacesServlet ");
        }
        viewToRender.setViewId(newViewId);
        if (context.getExternalContext().getRequest() instanceof ServletRequest) {
            log.info("getLocale ---\u30b9\u30ad\u30c3\u30d7");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Before dispacthMessage to newViewId " + newViewId);
        }
        context.getExternalContext().dispatch(newViewId);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("After dispacthMessage to newViewId " + newViewId);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        Map headerMap = extContext.getRequestHeaderMap();
        String contentType = null;
        String charEnc = null;
        contentType = (String)headerMap.get("Content-Type");
        if (null != contentType) {
            String charsetStr = "charset=";
            int len = charsetStr.length();
            int i = 0;
            i = contentType.indexOf(charsetStr);
            if (-1 != i && i + len < contentType.length()) {
                charEnc = contentType.substring(i + len);
            }
        }
        if (null == charEnc && null != extContext.getSession(false)) {
            charEnc = (String)extContext.getSessionMap().get("javax.faces.request.charset");
        }
        if (null != charEnc) {
            try {
                Object request;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("set character encoding on request to " + charEnc);
                }
                if ((request = extContext.getRequest()) instanceof ServletRequest) {
                    log.info("setCharacterEncoding \u30b9\u30ad\u30c3\u30d7");
                }
            }
            catch (Exception uee) {
                log.severe("219)" + uee.getMessage());
                throw new FacesException((Throwable)uee);
            }
        }
        String mapping = this.getFacesMapping(context);
        UIViewRoot viewRoot = null;
        if (mapping != null && !ViewHandlerImpl.isPrefixMapped(mapping)) {
            viewId = this.convertViewId(context, viewId);
        }
        if (extContext.getRequestPathInfo() == null && mapping != null && ViewHandlerImpl.isPrefixMapped(mapping)) {
            try {
                context.responseComplete();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Response Complete for" + viewId);
                }
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = context.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(context);
            log.info("(255) ------------------------- 2007/4/11 \u51e6\u7406\u5909\u66f4 restoreView()");
            viewRoot = Util.getStateManager(context).restoreView(context, viewId, renderKitId);
        }
        return viewRoot;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot result = new UIViewRoot();
        result.setViewId(viewId);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("291) Created new view for " + viewId);
        }
        if (locale == null) {
            locale = context.getApplication().getViewHandler().calculateLocale(context);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Using renderKitId from previous view " + renderKitId);
        }
        log.fine("(333)  UIViewRoot \u306b \u30ed\u30b1\u30fc\u30eb\u3092\u30bb\u30c3\u30c8\u3057\u307e\u3059 " + locale);
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        return result;
    }

    public Locale calculateLocale(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        log.finest("342) calculateLocale");
        Locale result = null;
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale perf = (Locale)locales.next();
            log.finest("350) perf = " + perf);
            result = this.findMatch(context, perf);
            if (result == null) continue;
            break;
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    public String calculateRenderKitId(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        String result = null;
        result = context.getApplication().getDefaultRenderKitId();
        if (null == result) {
            result = "HTML_BASIC";
        }
        return result;
    }

    protected Locale findMatch(FacesContext context, Locale perf) {
        Locale defaultLocale;
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = (Locale)it.next();
            if (perf.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!perf.getLanguage().equals(supportedLocale.getLanguage()) || !supportedLocale.getCountry().equals("")) continue;
            result = supportedLocale;
        }
        if (null == result && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (perf.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (perf.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().equals("")) {
                result = defaultLocale;
            }
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context;
            throw new NullPointerException(message);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Begin writing state to response for viewId" + context.getViewRoot().getViewId());
        }
        context.getResponseWriter().writeText((Object)"com.sun.faces.saveStateFieldMarker", null);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("End writing state to response for viewId" + context.getViewRoot().getViewId());
        }
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (context == null || viewId == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + "context " + context + " viewId " + viewId;
            throw new NullPointerException(message);
        }
        if (viewId.charAt(0) != '/') {
            String message = Util.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", new Object[]{viewId});
            log.severe("472) " + message + " " + viewId);
            throw new IllegalArgumentException(message);
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        String mapping = this.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (ViewHandlerImpl.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(".");
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    private String getFacesMapping(FacesContext context) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            if ((mapping = this.getMappingForRequest(servletPath, pathInfo)) == null) {
                String message = Util.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_CANNOT_BE_DETERMINED", new Object[]{servletPath});
                log.severe("581) " + message);
            }
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("servletPath " + servletPath);
            log.finest("pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (pathInfo == null && servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    private static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertViewId(FacesContext context, String viewId) {
        ViewHandlerImpl viewHandlerImpl = this;
        synchronized (viewHandlerImpl) {
            if (this.contextDefaultSuffix == null) {
                this.contextDefaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                log.info("666) contextDefaultSuffix = " + this.contextDefaultSuffix + "------------------------------****");
                if (this.contextDefaultSuffix == null) {
                    this.contextDefaultSuffix = ".jsp";
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("contextDefaultSuffix " + this.contextDefaultSuffix);
                }
            }
        }
        String convertedViewId = viewId;
        if (!convertedViewId.endsWith(this.contextDefaultSuffix)) {
            StringBuffer buffer = new StringBuffer(convertedViewId);
            int extIdx = convertedViewId.lastIndexOf(46);
            if (extIdx != -1) {
                buffer.replace(extIdx, convertedViewId.length(), this.contextDefaultSuffix);
            } else {
                buffer.append(this.contextDefaultSuffix);
            }
            convertedViewId = buffer.toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("viewId after appending the context suffix " + convertedViewId);
            }
        }
        return convertedViewId;
    }
}

