/*
 * Decompiled with CFR 0.152.
 */
package strawberry.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import strawberry.util.ActionForm;
import strawberry.util.BtvHtmlUtility;
import strawberry.util.EncodeUrl;

public class DebugModeBean {
    protected static final Logger log = Logger.getLogger("strawberry.application");
    EncodeUrl encodeUrl = new EncodeUrl();
    protected ServletContext appli = null;
    String servletName = "DebugModeServlet";
    protected static String fileSep = System.getProperty("file.separator");

    public void setApplicationContext(ServletContext newValue) {
        this.appli = newValue;
    }

    public ServletContext getServletContext() {
        return this.appli;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void showDetail(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
        res.setContentType(this.advisableContentType());
        PrintWriter out = res.getWriter();
        out.println("<html><head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=shift_jis\"></meta>");
        out.println("<meta http-equiv=\"Content-Style-Type\" content=\"text/css\"></meta>");
        out.println("</head><body>");
        String name = ac.getString("appli");
        if (name.length() > 0) {
            out.println("<h1>\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8 \u8a73\u7d30\u8868\u793a</h1>");
            Object obj = this.getServletContext().getAttribute(name);
            this.callHtml(obj);
            this.prettyPrint(out, obj);
        } else {
            name = ac.getString("session");
            out.println("<h1>\u30bb\u30c3\u30b7\u30e7\u30f3 \u8a73\u7d30\u8868\u793a</h1>");
            Object obj = ses.getAttribute(name);
            this.prettyPrint(out, obj);
        }
        out.println("</body></html>");
    }

    public void prettyPrint(PrintWriter out, Object obj) {
        Object tableHtml = this.callHtml(obj);
        if (tableHtml != null) {
            out.println((String)tableHtml);
        } else if (obj instanceof Map) {
            out.println(this.prettyPrintMap((Map)obj));
        } else if (obj instanceof List) {
            List list = (List)obj;
            out.println("<table border=1>");
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object inner = list.get(i);
                out.println("<tr>");
                out.println("<td>" + inner + "</td>");
                out.println("</tr>");
            }
            out.println("</table>");
        } else {
            out.println("<pre>");
            out.println(obj.toString());
            out.println("</pre>");
        }
    }

    public String prettyPrintMap(Map map) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<table border=1>");
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String clazz;
            String key = (String)it.next();
            Object obj = map.get(key);
            String val = obj == null ? "null" : obj.toString();
            String string = clazz = obj == null ? "" : obj.getClass().getName();
            if (key.startsWith("database")) {
                val = "secret";
            }
            key = BtvHtmlUtility.EncodeReplaceEntities(key);
            val = BtvHtmlUtility.EncodeReplaceEntities(val);
            pw.println("<tr><td>" + key + "</td><td>" + val + "</td><td>" + clazz + "</td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public Object callHtml(Object bean) {
        Object ret = null;
        Class<?> cls = bean.getClass();
        try {
            Method method = cls.getMethod("getHtml", null);
            ret = method.invoke(bean, (Object[])null);
        }
        catch (Exception ex) {
            log.info("138) " + cls.getName() + "#getHtml() not found");
        }
        return ret;
    }

    public void confirm(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
        res.setContentType(this.advisableContentType());
        PrintWriter out = res.getWriter();
        out.println("<html><body>");
        String value = ac.getString("appli");
        out.println("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8 " + value + "\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        out.println("<form>");
        out.println("<input type=submit value=\u5b9f\u884c>");
        out.println("<input type=hidden name='appli' value='" + value + "'>");
        out.println("<input type=hidden name='mode' value='del'>");
        out.println("</form>");
        out.println("</body></html>");
    }

    public void delete(ActionForm ac, HttpServletResponse res, HttpSession ses) throws Exception {
        String name = ac.getString("appli");
        this.getServletContext().removeAttribute(name);
        res.setContentType(this.advisableContentType());
        PrintWriter out = res.getWriter();
        out.println("<html><body>");
        out.println("<h1>\u524a\u9664\u5b8c\u4e86</h1>");
        out.println("<a href=" + this.servletName + ">\u623b\u308b</a>");
        out.println("</body></html>");
    }

    public void showInfo(HttpServletRequest req, HttpServletResponse res, HttpSession ses) throws Exception {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        res.setDateHeader("Expires", 0L);
        res.setContentType(this.advisableContentType());
        PrintWriter out = res.getWriter();
        out.println("<html><body>");
        out.println("<p>System.getProperty(java.version)=" + System.getProperty("java.version") + "</p>");
        out.println("<p>System.getProperty(javax.xml.parsers.SAXParserFactory)=" + System.getProperty("javax.xml.parsers.SAXParserFactory") + "</p>");
        out.println("<p>System.getProperty(javax.xml.parsers.DocumentBuilderFactory)=" + System.getProperty("javax.xml.parsers.DocumentBuilderFactory") + "</p>");
        String logClass = log.getClass().getName();
        out.println("<p>Logger.class =" + logClass + "</p>");
        Handler[] handler = log.getHandlers();
        if (handler == null) {
            out.println("<p>Logger.handler = null</p>");
        } else if (handler.length != 0) {
            for (int i = 0; i < handler.length; ++i) {
                Handler hand = handler[i];
                out.println("<p>Logger.handler(" + i + ") = " + hand.getClass().getName() + "</p>");
            }
        }
        Logger parent = log.getParent();
        out.println("<p>Logger.parent = " + parent + "</p>");
        this.printAttribute(out, this.getServletContext());
        this.printSession(out, ses);
        out.println("</body></html>");
    }

    public void printAttribute(PrintWriter pw, ServletContext appli) {
        Enumeration e = appli.getAttributeNames();
        pw.print("<h2>\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u30fb\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3000");
        pw.print(Integer.toHexString(appli.hashCode()));
        pw.println("</h2>");
        pw.println("<table border=1>");
        pw.println(" <tr>");
        pw.println(" <td>\u5c5e\u6027\u540d</td><td>\u30af\u30e9\u30b9\u540d</td><td>\u30af\u30e9\u30b9\u30ed\u30fc\u30c0</td><td>\u64cd\u4f5c</td>");
        pw.println(" </tr>");
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object obj = appli.getAttribute(attrName);
            pw.print("  <td>" + attrName + "</td>");
            pw.println("<td>" + obj.getClass().getName() + "</td>");
            pw.println("<td>" + this.showClassLoader(obj) + "</td>");
            pw.print("  <td><a href='" + this.servletName + "?mode=confirm&appli=" + attrName + "'>\u524a\u9664</a>\u3000|\u3000");
            pw.print("    <a href='" + this.servletName + "?mode=show&appli=" + attrName + "'>\u8868\u793a</a></td>");
            pw.println(" </tr>");
        }
        pw.println("</table>");
    }

    public String showClassLoader(Object obj) {
        String x = "null";
        if (obj.getClass() != null) {
            ClassLoader loader = obj.getClass().getClassLoader();
            String string = x = loader == null ? "null" : loader.toString();
            if (x.length() > 40) {
                x = x.substring(0, 39);
            }
        }
        return x;
    }

    public void printSession(PrintWriter pw, HttpSession ses) {
        Enumeration e = ses.getAttributeNames();
        pw.print("<h2>\u30bb\u30c3\u30b7\u30e7\u30f3\u3000");
        pw.print(Integer.toHexString(ses.hashCode()));
        pw.println("</h2>");
        pw.println("<table border=1>");
        pw.println(" <tr>");
        pw.println(" <td>\u5c5e\u6027\u540d</td><td>\u30af\u30e9\u30b9\u540d</td><td>\u30af\u30e9\u30b9\u30ed\u30fc\u30c0</td><td>\u64cd\u4f5c</td>");
        pw.println(" </tr>");
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object obj = ses.getAttribute(attrName);
            pw.print("  <td>" + attrName + "</td>");
            pw.println("<td>" + obj.getClass().getName() + "</td>");
            pw.println("<td>" + this.showClassLoader(obj) + "</td>");
            pw.print("  <td>");
            String wk = this.servletName + "?mode=show&session=" + attrName;
            pw.print("    <a href='" + this.encodeUrl.convert(wk) + "'>\u8868\u793a</a></td>");
            pw.println(" </tr>");
        }
        pw.println("</table>");
    }

    public String advisableContentType() {
        return "text/html; charset=\"Windows-31J\"";
    }
}

