/*
 * Decompiled with CFR 0.152.
 */
package strawberry.script;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import strawberry.plugin.ScriptEngine;

public class FesiEngineImpl
extends ScriptEngine {
    protected static final Logger log = Logger.getLogger("strawberry.script");
    boolean bInitialized = false;
    JSGlobalObject global = null;
    String[] extensions = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.JavaAccess", "FESI.Extensions.FileIO"};

    public void addScriptableObject(String name, Object obj) {
        this.initIfNecessary();
        try {
            this.global.setMember(name, obj);
        }
        catch (JSException e) {
            throw new RuntimeException(e);
        }
    }

    public Object evaluateString(String source, String sourceName, int lineNum) {
        this.initIfNecessary();
        Object securytyDomain = null;
        log.info("source = " + source);
        log.info("global = " + this.global.getClass().getName());
        Object result = null;
        try {
            result = this.global.eval(source);
        }
        catch (JSException e) {
            Throwable oe = e.getOriginatingException();
            if (oe != null) {
                log.log(Level.WARNING, "50) catch JSException", oe);
            } else {
                log.log(Level.WARNING, "50) catch JSException", e);
            }
            throw new FacesException(e.getMessage());
        }
        log.info("result = " + result);
        return result;
    }

    public void initIfNecessary() {
        if (!this.bInitialized) {
            try {
                this.global = JSUtil.makeEvaluator(this.extensions);
            }
            catch (JSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.bInitialized = true;
        }
    }

    public void release() {
        log.info("release \u304c\u547c\u3070\u308c\u307e\u3057\u305f");
        if (this.bInitialized) {
            // empty if block
        }
    }
}

