/*
 * Decompiled with CFR 0.152.
 */
package strawberry.renderkit;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import strawberry.renderkit.DateData;

public class DateInputPulldownRenderer
extends Renderer {
    protected static final Logger log = Logger.getLogger("strawberry.ren.DateInputPulldownRenderer");
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    static final int TABINDEX_HAS_NO_VALUE = -9999;

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        String family = component.getFamily();
        String rendererType = component.getRendererType();
        Renderer rend = context.getRenderKit().getRenderer(family, rendererType);
        if (rend == null) {
            log.warning("Renderer not found!!    '" + family + "', '" + rendererType);
        } else {
            rend.encodeBegin(context, component);
            rend.encodeChildren(context, component);
            rend.encodeEnd(context, component);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object wk = this._getConvertedValue(context, component, submittedValue);
        if (log.isLoggable(Level.FINE)) {
            if (wk == null) {
                log.fine("getConvertedValue -->  " + wk);
            } else {
                log.fine("getConvertedValue -->  " + wk + ", " + wk.getClass().getName());
            }
        }
        return wk;
    }

    private Object _getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Date rc = null;
        DateData userData = (DateData)submittedValue;
        try {
            rc = userData.parseDate();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "catch Exception ----------------------------", e);
            }
            throw new ConverterException(new FacesMessage("\u65e5\u4ed8\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
        }
        return rc;
    }

    public void decode(FacesContext context, UIComponent component) {
        EditableValueHolder uii = (EditableValueHolder)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Locale currentLocale = Locale.getDefault();
        DateData userData = (DateData)uii.getSubmittedValue();
        if (userData == null) {
            Object obj = uii.getValue();
            if (obj == null) {
                userData = new DateData();
            } else if (obj instanceof java.util.Date) {
                userData = new DateData((java.util.Date)obj, currentLocale, null, false);
            } else if (obj instanceof String) {
                userData = new DateData();
                userData.setDate((String)obj);
            } else {
                log.warning("obj = " + obj + ", class = " + obj.getClass().getName());
            }
        }
        String clientId = component.getClientId(context);
        log.fine("decode --  " + clientId);
        if (clientId != null) {
            String yy = (String)requestMap.get(clientId + "_yy");
            String mm = (String)requestMap.get(clientId + "_mm");
            String dd = (String)requestMap.get(clientId + "_dd");
            yy = yy == null ? "" : yy.trim();
            mm = mm == null ? "" : mm.trim();
            dd = dd == null ? "" : dd.trim();
            log.finer("!!!!!!!!!! yy = " + yy + ", mm = " + mm + ", dd = " + dd);
            userData.setDay(dd);
            userData.setMonth(mm);
            userData.setYear(yy);
            uii.setSubmittedValue((Object)userData);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin encoding component " + component.getId());
        }
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        ResponseWriter writer = context.getResponseWriter();
        if (this.spanned(component)) {
            writer.startElement("span", component);
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        if (clientId == null) {
            throw new NullPointerException();
        }
        String id = component.getId();
        EditableValueHolder uii = (EditableValueHolder)component;
        DateData dateData = null;
        Object obj = uii.getValue();
        if (obj != null) {
            String sdate;
            java.util.Date ts;
            if (obj instanceof DateData) {
                log.fine("********************* 150\u884c\u76ee DateData");
                dateData = (DateData)obj;
            } else if (obj instanceof String) {
                log.fine("********************* 153\u884c\u76ee String");
                dateData = new DateData();
                dateData.setDate((String)obj);
            } else if (obj instanceof Timestamp) {
                log.fine("********************* 157\u884c\u76ee Timestamp");
                ts = (Timestamp)obj;
                sdate = this.simpleDateFormat.format(ts);
                dateData = new DateData();
                dateData.setDate(sdate);
            } else if (obj instanceof Date) {
                log.fine("********************* 163\u884c\u76ee java.sql.Date");
                ts = (Date)obj;
                sdate = this.simpleDateFormat.format(ts);
                dateData = new DateData();
                dateData.setDate(sdate);
            } else {
                log.fine("********************* 169\u884c\u76ee " + obj.getClass().getName());
            }
        }
        if (dateData == null) {
            obj = uii.getSubmittedValue();
        }
        if (obj instanceof DateData) {
            dateData = (DateData)obj;
        } else if (obj instanceof String) {
            dateData = new DateData();
            dateData.setDate((String)obj);
        }
        log.fine("********************* 192\u884c\u76ee " + dateData);
        if (null == dateData) {
            Map initParam = context.getExternalContext().getInitParameterMap();
            GregorianCalendar cal3 = null;
            Object debug = initParam.get("debug.GregorianCalendar");
            cal3 = debug != null ? (GregorianCalendar)debug : new GregorianCalendar();
            String strDate = new SimpleDateFormat("yyyy-MM-dd").format(cal3.getTime());
            dateData = new DateData();
            dateData.setDate(strDate);
        }
        Object cc = null;
        String strUnselectValue = (String)component.getAttributes().get("writeUnselectValue");
        boolean writeUnselectValue = true;
        if (strUnselectValue != null && "false".equalsIgnoreCase(strUnselectValue)) {
            writeUnselectValue = false;
        }
        int tabIndex = -9999;
        HtmlInputText htmlInputText = null;
        if (component instanceof HtmlInputText) {
            htmlInputText = (HtmlInputText)component;
        } else {
            log.fine("(213) component = " + component.getClass().getName());
        }
        if (htmlInputText != null) {
            String strTab = htmlInputText.getTabindex();
            log.info("(220) strTab = " + strTab);
            if (strTab != null) {
                tabIndex = Integer.parseInt(strTab);
            }
        }
        int fromYear = 2005;
        Object wkYearFrom = component.getAttributes().get("yearFrom");
        if (wkYearFrom == null) {
            log.fine("(226) yearFrom = null");
        } else if (wkYearFrom instanceof String) {
            String strYearFrom = (String)wkYearFrom;
            fromYear = Integer.parseInt(strYearFrom);
        } else if (wkYearFrom instanceof Long) {
            Long lngYearFrom = (Long)wkYearFrom;
            fromYear = lngYearFrom.intValue();
        } else {
            log.fine("(231) class = " + wkYearFrom.getClass().getName());
        }
        if (fromYear == 0) {
            fromYear = 2000;
        }
        int toYear = 2010;
        Object wkYearTo = component.getAttributes().get("yearTo");
        if (wkYearTo == null) {
            log.fine("(228) yearTo = null");
        } else if (wkYearTo instanceof String) {
            String strYearTo = (String)wkYearTo;
            toYear = Integer.parseInt(strYearTo);
        } else if (wkYearTo instanceof Long) {
            Long lngYearTo = (Long)wkYearTo;
            toYear = lngYearTo.intValue();
        } else {
            log.fine("(234) class = " + wkYearTo.getClass().getName());
        }
        if (toYear == 0) {
            toYear = 2010;
        }
        this.writeInputTag(writer, clientId + "_yy", id + "_yy", dateData.getYear(), context, cc, writeUnselectValue, fromYear, toYear, tabIndex);
        writer.writeText((Object)"\u5e74", "\u5e74");
        if (tabIndex >= 0) {
            ++tabIndex;
        }
        this.writeInputTag(writer, clientId + "_mm", id + "_mm", dateData.getMonth(), context, cc, writeUnselectValue, 1, 12, tabIndex);
        writer.writeText((Object)"\u6708", "\u6708");
        if (tabIndex >= 0) {
            ++tabIndex;
        }
        this.writeInputTag(writer, clientId + "_dd", id + "_dd", dateData.getDay(), context, cc, writeUnselectValue, 1, 31, tabIndex);
        writer.writeText((Object)"\u65e5", "\u65e5");
        if (this.spanned(component)) {
            writer.endElement("span");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding component " + component.getId());
        }
    }

    private void writeInputTag(ResponseWriter writer, String clientId, String id, String value, FacesContext context, Object cc, boolean writeUnselectValue, int from, int to, int tabIndex) throws IOException {
        writer.startElement("select", null);
        writer.writeAttribute("name", (Object)clientId, "clientId");
        if (tabIndex != -9999) {
            writer.writeAttribute("tabindex", (Object)("" + tabIndex), "tabindex");
        }
        this.writePulldown(writer, from, to, value, writeUnselectValue);
        writer.endElement("select");
    }

    private void writePulldown(ResponseWriter writer, int start, int end, String value, boolean writeUnselectValue) throws IOException {
        if (writeUnselectValue) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)"unselected", "value");
            writer.writeText((Object)"\u3000", null);
            writer.endElement("option");
        }
        for (int i = start; i <= end; ++i) {
            writer.startElement("option", null);
            String str = "" + i;
            writer.writeAttribute("value", (Object)str, "value");
            if (value != null && this.compareString(value, str)) {
                writer.writeAttribute("selected", (Object)"selected", "selected");
            }
            writer.writeText((Object)str, null);
            writer.endElement("option");
        }
    }

    public boolean compareString(String val1, String val2) {
        if (val1.startsWith("0")) {
            val1 = val1.substring(1);
        }
        if (val2.startsWith("0")) {
            val2 = val1.substring(1);
        }
        return val1.equals(val2);
    }

    private boolean spanned(UIComponent component) {
        return true;
    }
}

