/*
 * Decompiled with CFR 0.152.
 */
package strawberry.renderkit;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;

public class DateData
implements Serializable {
    static final long serialVersionUID = -835420431554223807L;
    private String day;
    private String month;
    private String year;
    private String hours;
    private String minutes;
    private String seconds;

    public String toString() {
        return this.getClass().getName() + "[" + this.year + "/" + this.month + "/" + this.day + " " + this.hours + ":" + this.minutes + ":" + this.seconds + "]";
    }

    public DateData() {
    }

    public void setDate(String str) {
        String[] arr = str.split("-");
        if (arr.length >= 1) {
            this.year = arr[0];
        }
        if (arr.length >= 2) {
            this.month = arr[1];
        }
        if (arr.length >= 3) {
            this.day = arr[2];
        }
    }

    public void setTime(String str) {
        String[] arr = str.split(":");
        if (arr.length >= 1) {
            this.hours = arr[0];
        }
        if (arr.length >= 2) {
            this.minutes = arr[1];
        }
        if (arr.length >= 3) {
            this.seconds = arr[2];
        }
    }

    public DateData(Date date, Locale currentLocale, String _timeZone, boolean uses_ampm) {
        int int_hours;
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance(currentLocale);
        calendar.setTime(date);
        this.day = Integer.toString(calendar.get(5));
        this.month = Integer.toString(calendar.get(2) + 1);
        this.year = Integer.toString(calendar.get(1));
        if (uses_ampm && (int_hours = calendar.get(10)) == 0) {
            int_hours = 12;
        }
    }

    public java.sql.Date parseDate() throws ParseException {
        if (this.day == null || this.month == null || this.year == null) {
            return null;
        }
        if (this.day.length() == 0 && this.month.length() == 0 && this.year.length() == 0) {
            return null;
        }
        if ("unselected".equals(this.day) || "unselected".equals(this.month) || "unselected".equals(this.year)) {
            return null;
        }
        return java.sql.Date.valueOf(this.year + "-" + this.month + "-" + this.day);
    }

    public Time parseTime() throws ParseException {
        if (this.seconds == null || this.minutes == null || this.hours == null) {
            return null;
        }
        if (this.seconds.length() == 0 && this.minutes.length() == 0 && this.hours.length() == 0) {
            return null;
        }
        if ("unselected".equals(this.seconds) || "unselected".equals(this.minutes) || "unselected".equals(this.hours)) {
            return null;
        }
        if (!(this.hours.matches("[0-9]*") && this.minutes.matches("[0-9]*") && this.seconds.matches("[0-9]*"))) {
            throw new ConverterException(new FacesMessage("\u6642\u9593\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
        }
        int iHours = Integer.parseInt(this.hours);
        int iMinutes = Integer.parseInt(this.minutes);
        int iSeconds = Integer.parseInt(this.seconds);
        if (iHours < 0 || 24 <= iHours || iMinutes < 0 || 60 <= iMinutes || iSeconds < 0 || 60 <= iSeconds) {
            throw new ConverterException(new FacesMessage("\u6642\u9593\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
        }
        return Time.valueOf(this.hours + ":" + this.minutes + ":" + this.seconds);
    }

    public Timestamp parseTimestamp() throws ParseException {
        if (this.seconds == null || this.minutes == null || this.hours == null) {
            return null;
        }
        if (this.seconds.length() == 0 && this.minutes.length() == 0 && this.hours.length() == 0) {
            return null;
        }
        if ("unselected".equals(this.seconds) || "unselected".equals(this.minutes) || "unselected".equals(this.hours)) {
            return null;
        }
        if (!(this.hours.matches("[0-9]*") && this.minutes.matches("[0-9]*") && this.seconds.matches("[0-9]*"))) {
            throw new ConverterException(new FacesMessage("\u6642\u9593\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
        }
        int iHours = Integer.parseInt(this.hours);
        int iMinutes = Integer.parseInt(this.minutes);
        int iSeconds = Integer.parseInt(this.seconds);
        if (iHours < 0 || 24 <= iHours || iMinutes < 0 || 60 <= iMinutes || iSeconds < 0 || 60 <= iSeconds) {
            throw new ConverterException(new FacesMessage("\u6642\u9593\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
        }
        return Timestamp.valueOf(this.year + "-" + this.month + "-" + this.day + " " + this.hours + ":" + this.minutes + ":" + this.seconds);
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }
}

