/*
 * Decompiled with CFR 0.152.
 */
package strawberry.mockup;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class MockHttpSession
implements HttpSession {
    protected static final Logger log = Logger.getLogger("strawberry.ctx.session");
    public static final String SESSION_COOKIE_NAME = "JSESSION";
    private static int nextId = 1;
    private final String id = Integer.toString(nextId++);
    private final long creationTime = System.currentTimeMillis();
    private int maxInactiveInterval;
    private long lastAccessedTime = System.currentTimeMillis();
    private ServletContext servletContext;
    private final Hashtable attributes = new Hashtable();
    private boolean invalid = false;
    private boolean isNew = true;

    public long getCreationTime() {
        log.finer("getCreationTime");
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public void access() {
        log.finer("access");
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    public long getLastAccessedTime() {
        log.finer("getLastAccessedTime");
        return this.lastAccessedTime;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new NullPointerException();
        }
        return this.servletContext;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
    }

    public void setMaxInactiveInterval(int interval) {
        log.finer("setMaxInactiveInterval");
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        log.finer("getMaxInactiveInterval");
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("getSessionContext");
    }

    public Object getAttribute(String name) {
        log.finer("getAttribute");
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        log.finer("getValue");
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        log.finer("getAttributeNames");
        return this.attributes.keys();
    }

    public String[] getValueNames() {
        log.finer("getValueNames");
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void setAttribute(String name, Object value) {
        log.finer("setAttribute");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void putValue(String name, Object value) {
        log.finer("putValue");
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        log.finer("removeAttribute");
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        log.finer("removeValue");
        this.removeAttribute(name);
    }

    public void invalidate() {
        log.finer("invalidate");
        this.invalid = true;
        this.attributes.clear();
    }

    public boolean isInvalid() {
        log.finer("isInvalid");
        return this.invalid;
    }

    public void setNew(boolean value) {
        log.finer("setNew");
        this.isNew = value;
    }

    public boolean isNew() {
        log.finer("isNew");
        return this.isNew;
    }
}

