/*
 * Decompiled with CFR 0.152.
 */
package strawberry.mockup;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class MockHttpServletResponse
implements HttpServletResponse {
    protected static final Logger log = Logger.getLogger("strawberry.ctx.response");
    public static final int DEFAULT_SERVER_PORT = 80;
    private String characterEncoding = "MS932";
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private final ServletOutputStream outputStream = null;
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private final List cookies = new ArrayList();
    private final Map headers = new HashMap();
    private int status = 200;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;

    public void setCharacterEncoding(String characterEncoding) {
        log.fine("-------------------- setCharacterEncoding ");
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        log.fine("-------------------- getCharacterEncoding ");
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        log.fine("-------------------- getOutputStream ");
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        log.fine("-------------------- getWriter ");
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public void setContentLength(int contentLength) {
        log.fine("-------------------- setContentLength ");
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        log.fine("-------------------- setContentType '" + contentType + "'");
        this.contentType = contentType;
    }

    public String getContentType() {
        log.fine("-------------------- getContentType ");
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        log.fine("-------------------- setBufferSize ");
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        log.fine("-------------------- getBufferSize ");
        return this.bufferSize;
    }

    public void flushBuffer() {
        log.fine("-------------------- flushBuffer ");
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void resetBuffer() {
        log.fine("-------------------- resetBuffer ");
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        log.fine("-------------------- isCommitted ");
        return this.committed;
    }

    public void reset() {
        log.fine("-------------------- reset ");
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(Locale locale) {
        log.fine("-------------------- setLocale ");
        this.locale = locale;
    }

    public Locale getLocale() {
        log.fine("-------------------- getLocale ");
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        log.fine("-------------------- addCookie ");
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public Cookie getCookie(String name) {
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            Cookie cookie = (Cookie)it.next();
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public boolean containsHeader(String name) {
        log.fine("-------------------- containsHeader ");
        return this.headers.containsKey(name);
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public List getHeaders(String name) {
        Object value = this.headers.get(name);
        if (value instanceof List) {
            return (List)value;
        }
        if (value != null) {
            return Collections.singletonList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public Set getHeaderNames() {
        return this.headers.keySet();
    }

    public String encodeURL(String url) {
        log.fine("-------------------- encodeURL ");
        return url;
    }

    public String encodeRedirectURL(String url) {
        log.fine("-------------------- encodeRedirectURL ");
        return url;
    }

    public String encodeUrl(String url) {
        log.fine("-------------------- encodeUrl ");
        return url;
    }

    public String encodeRedirectUrl(String url) {
        log.fine("-------------------- encodeRedirectUrl ");
        return url;
    }

    public void sendError(int status, String errorMessage) throws IOException {
        log.fine("-------------------- sendError ");
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.errorMessage = errorMessage;
        this.committed = true;
    }

    public void sendError(int status) throws IOException {
        log.fine("-------------------- sendError ");
        if (this.committed) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.status = status;
        this.committed = true;
    }

    public void sendRedirect(String url) throws IOException {
        log.fine("-------------------- sendRedirect ");
        if (this.committed) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        this.redirectedUrl = url;
        this.committed = true;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setDateHeader(String name, long value) {
        log.fine("-------------------- setDateHeader ");
        this.headers.put(name, new Long(value));
    }

    public void addDateHeader(String name, long value) {
        log.fine("-------------------- addDateHeader ");
        this.doAddHeader(name, new Long(value));
    }

    public void setHeader(String name, String value) {
        log.fine("-------------------- setHeader ");
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        log.fine("-------------------- addHeader ");
        this.doAddHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        log.fine("-------------------- setIntHeader ");
        this.headers.put(name, new Integer(value));
    }

    public void addIntHeader(String name, int value) {
        log.fine("-------------------- addIntHeader ");
        this.doAddHeader(name, new Integer(value));
    }

    private void doAddHeader(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        Object oldValue = this.headers.get(name);
        if (oldValue instanceof List) {
            List list = (List)oldValue;
            list.add(value);
        } else if (oldValue != null) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(oldValue);
            list.add(value);
            this.headers.put(name, list);
        } else {
            this.headers.put(name, value);
        }
    }

    public void setStatus(int status) {
        log.fine("-------------------- setStatus ");
        this.status = status;
    }

    public void setStatus(int status, String errorMessage) {
        log.fine("-------------------- setStatus ");
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

