/*
 * Decompiled with CFR 0.152.
 */
package strawberry.mockup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import strawberry.mockup.MockHttpSession;

public class MockHttpServletRequest
implements HttpServletRequest {
    protected static final Logger log = Logger.getLogger("strawberry.ctx.request");
    protected static final Logger headLog = Logger.getLogger("strawberry.ctx.header");
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private final Hashtable attributes = new Hashtable();
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private final Map parameters = new Hashtable();
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final Vector locales = new Vector();
    private boolean secure = false;
    private ServletContext servletContext = null;
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    private String authType;
    private Cookie[] cookies;
    private final Hashtable headers = new Hashtable();
    private String method = "GET";
    private String pathInfo;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private final Set userRoles = new HashSet();
    private Principal userPrincipal;
    private String requestURI = "";
    private String servletPath = "";
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;
    RequestDispatcher requestDispatcher = null;

    public MockHttpServletRequest(ServletContext servletContext) {
        this.locales.add(Locale.ENGLISH);
        this.servletContext = servletContext;
        log.finer("\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\uff11");
    }

    public MockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this.servletContext = servletContext;
        this.method = method;
        this.requestURI = requestURI;
        this.locales.add(Locale.ENGLISH);
        log.finer("\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\uff13");
    }

    public MockHttpServletRequest() {
        this.locales.add(Locale.ENGLISH);
        log.finer("\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\uff10");
    }

    public Object getAttribute(String name) {
        log.finer("getAttribute ####");
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        log.finer("getAttributeNames ####");
        return this.attributes.keys();
    }

    public String getCharacterEncoding() {
        log.finer("getCharacterEncoding ####");
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        log.finer("setCharacterEncoding ####");
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        log.finer("setContent ####");
        this.content = content;
    }

    public int getContentLength() {
        log.finer("getContentLength ####");
        return this.content != null ? this.content.length : -1;
    }

    public void setContentType(String contentType) {
        log.finer("setContentType ####");
        this.contentType = contentType;
    }

    public String getContentType() {
        log.finer("getContentType ####");
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        log.finer("getInputStream ####");
        return null;
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        String[] oldArr = (String[])this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public String getParameter(String name) {
        String[] arr = (String[])this.parameters.get(name);
        String ans = arr != null && arr.length > 0 ? arr[0] : null;
        log.fine("257) getParameter(" + name + ")  ==> " + ans);
        return ans;
    }

    public Enumeration getParameterNames() {
        log.finer("getParameterNames ####");
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        log.finer("getParameterValues ####");
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        log.finer("getParameterMap ####");
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setProtocol(String protocol) {
        log.finer("setProtocol ####");
        this.protocol = protocol;
    }

    public String getProtocol() {
        log.finer("setProtocol ####");
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        log.finer("getScheme ####");
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        log.finer("getServerName ####");
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        log.finer("getServerPort ####");
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        log.finer("getRemoteAddr ####");
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        log.finer("getRemoteHost ####");
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        log.finer("setAttribute ####");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        log.finer("removeAttribute ####");
        this.attributes.remove(name);
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        log.finer("getLocale ####");
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        log.finer("getLocales ####");
        return this.locales.elements();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        log.finer("getRequestDispatcher ####");
        return this.requestDispatcher;
    }

    public String getRealPath(String path) {
        log.finer("getRealPath ####");
        return this.servletContext.getRealPath(path);
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        log.finer("getRemotePort ####");
        return this.remotePort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        log.finer("getLocalName ####");
        return this.localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        log.finer("getLocalAddr ####");
        return this.localAddr;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        log.finer("getAuthType ####");
        return this.authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies() {
        log.finer("getCookies ####");
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        Object oldValue = this.headers.get(name);
        if (oldValue instanceof List) {
            List list = (List)oldValue;
            this.addHeaderValue(list, value);
        } else if (oldValue != null) {
            LinkedList list = new LinkedList();
            list.add(oldValue);
            this.addHeaderValue(list, value);
            this.headers.put(name, list);
        } else if (value instanceof Collection || value.getClass().isArray()) {
            LinkedList list = new LinkedList();
            this.addHeaderValue(list, value);
            this.headers.put(name, list);
        } else {
            headLog.info("490) " + name + ", " + value);
            this.headers.put(name, value);
        }
    }

    private void addHeaderValue(List list, Object value) {
        if (value instanceof Collection) {
            Collection valueColl = (Collection)value;
            Iterator it = valueColl.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                list.add(element.toString());
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                list.add(element.toString());
            }
        } else {
            list.add(value);
        }
    }

    public long getDateHeader(String name) {
        log.finer("getDateHeader ####");
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        Object value = this.headers.get(name);
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is neither a Date nor a Number: " + value);
        }
        return -1L;
    }

    public String getHeader(String name) {
        log.finer("getHeader ####");
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        Object value = this.headers.get(name);
        String cls = "null";
        if (value != null) {
            cls = value.getClass().getName();
        }
        headLog.fine("540) " + value + ", " + cls);
        if (value instanceof List) {
            throw new RuntimeException();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        Object value = this.headers.get(name);
        if (value instanceof List) {
            return Collections.enumeration((List)value);
        }
        if (value != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.add(value.toString());
            return vector.elements();
        }
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        Object value = this.headers.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number: " + value);
        }
        return -1;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        log.finer("getMethod return s ==> " + this.method);
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        log.fine("getPathInfo return s ==> " + this.pathInfo);
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        log.finer("getContextPath return s ==> " + this.contextPath);
        return this.contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        log.finer("getQueryString return s ==> " + this.queryString);
        return this.queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        log.finer("getRemoteUser return s ==> " + this.remoteUser);
        return this.remoteUser;
    }

    public void addRole(String role) {
        this.addUserRole(role);
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session != null ? session.getId() : null;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        log.finer("getRequestURI returns => " + this.requestURI);
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        log.fine("getServletPath returns => " + this.servletPath);
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession(boolean create) {
        HttpSession ses = this._getSession(create);
        log.finer("getSession create(" + create + ") => " + ses);
        return ses;
    }

    private HttpSession _getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new MockHttpSession();
        }
        return this.session;
    }

    public HttpSession getSession() {
        HttpSession ses = this._getSession(true);
        log.finer("getSession create() => " + ses);
        return ses;
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }
}

