/*
 * Decompiled with CFR 0.152.
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;

public class UpdateModelValuesPhase
extends Phase {
    protected static final Logger log = Logger.getLogger("strawberry.UpdateModelValuesPhase");

    public PhaseId getId() {
        return PhaseId.UPDATE_MODEL_VALUES;
    }

    public void execute(FacesContext facesContext) {
        UIViewRoot component;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering UpdateModelValuesPhase");
        }
        Util.doAssert(null != (component = facesContext.getViewRoot()));
        String exceptionMessage = null;
        try {
            this.recursiveUpdate(facesContext, (UIComponent)component);
            log.config("recursiveUpdate success!");
        }
        catch (IllegalStateException e) {
            exceptionMessage = e.getMessage();
        }
        catch (FacesException fe) {
            exceptionMessage = fe.getMessage();
        }
        if (null != exceptionMessage) {
            Object[] params = new Object[3];
            params[2] = exceptionMessage;
            facesContext.addMessage(component.getClientId(facesContext), MessageFactory.getMessage(facesContext, "com.sun.faces.MODELUPDATE_ERROR", params));
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, exceptionMessage);
            }
        }
    }

    public void recursiveUpdate(FacesContext facesContext, UIComponent component) throws FacesException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("recursiveUpdate:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
        }
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.recursiveUpdate(facesContext, kid);
        }
        if (component instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)component;
            log.fine("138) call processUpdates:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
            log.fine("141)  isValid:" + evh.isValid() + ", isLocalValueSet = " + evh.isLocalValueSet());
            ValueBinding vb = component.getValueBinding("value");
            log.fine("145)  vb: " + vb + ", LocalValue: " + evh.getLocalValue());
            component.processUpdates(facesContext);
        }
    }
}

