/*
 * Decompiled with CFR 0.152.
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import strawberry.ViewIdUtil;
import strawberry.tree.TreePrinter;

public class RestoreViewPhase
extends Phase {
    protected static final Logger log = Logger.getLogger("strawberry.lifecycle");
    protected static final Logger logTree = Logger.getLogger("strawberry.tree");
    TreePrinter treePrinter = null;

    public RestoreViewPhase() {
    }

    public RestoreViewPhase(Object obj) {
        this.treePrinter = (TreePrinter)obj;
    }

    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        Object request;
        if (null == facesContext) {
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = null;
        if (viewRoot != null) {
            log.fine("(136) a pre created view  \u304c\u898b\u3064\u304b\u3063\u305f");
            locale = facesContext.getExternalContext().getRequestLocale();
            facesContext.getViewRoot().setLocale(locale);
            this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
            return;
        }
        log.fine("(143)  viewRoot \u306fnull\u3067\u3059");
        ExternalContext ec = facesContext.getExternalContext();
        Map requestMap = ec.getRequestMap();
        String viewId = (String)requestMap.get("javax.servlet.include.path_info");
        if (ViewIdUtil.isCustomizedViewId(ec)) {
            viewId = ec.getRequestServletPath() + ec.getRequestPathInfo();
        } else if (viewId == null) {
            viewId = ec.getRequestPathInfo();
        }
        log.fine("(118)  viewId  '" + viewId + "' --------------------------------------");
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null && (request = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
            viewId = ((HttpServletRequest)request).getServletPath();
        }
        if (viewId == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("viewId is null");
            }
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR"));
        }
        viewRoot = Util.getViewHandler(facesContext).restoreView(facesContext, viewId);
        if (null == viewRoot) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("(193) New request: creating a view for " + viewId);
            }
            viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
            log.fine("165) context.renderResponse()\u3092\u547c\u3073\u307e\u3059 ");
            facesContext.renderResponse();
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("(169) Postback: Restored view for " + viewId);
        }
        Util.doAssert(null != viewRoot);
        facesContext.setViewRoot(viewRoot);
        this.doPerComponentActions(facesContext, (UIComponent)viewRoot);
        if (log.isLoggable(Level.CONFIG)) {
            this.inspectTree((UIComponent)viewRoot, facesContext);
        }
    }

    public void inspectTree(UIComponent viewRoot, FacesContext facesContext) {
        Level wk = logTree.getLevel();
        int iVal = 0;
        if (wk == null) {
            logTree.finer("175) NullPointer\u56de\u907f");
            return;
        }
        iVal = wk.intValue();
        if (this.treePrinter != null) {
            this.treePrinter.print(logTree, wk, viewRoot, "  ");
        }
    }

    protected void doPerComponentActions(FacesContext context, UIComponent uic) {
        Iterator kids = uic.getFacetsAndChildren();
        if (kids == null) {
            log.info("kids == null : " + uic);
        }
        while (kids.hasNext()) {
            this.doPerComponentActions(context, (UIComponent)kids.next());
        }
        ValueBinding valueBinding = null;
        valueBinding = uic.getValueBinding("binding");
        if (null != valueBinding) {
            valueBinding.setValue(context, (Object)uic);
        }
    }
}

