/*
 * Decompiled with CFR 0.152.
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class ProcessValidationsPhase
extends Phase {
    protected static final Logger log = Logger.getLogger("strawberry.lifecycle");

    public PhaseId getId() {
        return PhaseId.PROCESS_VALIDATIONS;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        log.finer("Entering ProcessValidationsPhase");
        UIViewRoot component = facesContext.getViewRoot();
        Util.doAssert(null != component);
        try {
            this.recursiveValidate(facesContext, (UIComponent)component);
        }
        catch (RuntimeException re) {
            String exceptionMessage = re.getMessage();
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "101) catch RuntimeException", re);
            }
            throw new FacesException(exceptionMessage, (Throwable)re);
        }
        log.finer("Exiting ProcessValidationsPhase");
    }

    public void recursiveValidate(FacesContext facesContext, UIComponent component) throws FacesException {
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.recursiveValidate(facesContext, kid);
        }
        if (component instanceof UIInput) {
            component.processValidators(facesContext);
        }
    }
}

