/*
 * Decompiled with CFR 0.152.
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import strawberry.event.PhaseListenerImpl;
import strawberry.lifecycle.LifecycleImpl;
import strawberry.lifecycle.LifecycleImpl2;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    static final int FIRST_PHASE = PhaseId.RESTORE_VIEW.getOrdinal();
    static final int LAST_PHASE = PhaseId.RENDER_RESPONSE.getOrdinal();
    protected static final Logger log = Logger.getLogger("strawberry.lifecycle");
    protected HashMap lifecycleMap = null;
    protected Object lock = null;

    public LifecycleFactoryImpl() {
        Object treePrinter = null;
        try {
            treePrinter = Class.forName("strawberry.tree.TreePrinterImpl").newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.lifecycleMap = new HashMap();
        LifecycleImpl wkImpl = new LifecycleImpl(treePrinter);
        wkImpl.addPhaseListener(new PhaseListenerImpl());
        this.lifecycleMap.put("DEFAULT", new LifecycleWrapper(wkImpl, false));
        LifecycleImpl2 life2 = new LifecycleImpl2(treePrinter);
        life2.addPhaseListener(new PhaseListenerImpl());
        this.lifecycleMap.put("Strawberry", new LifecycleWrapper(life2, false));
        if (log.isLoggable(Level.FINER)) {
            log.finer("Created Default Lifecycle");
        }
        this.lock = new Object();
    }

    boolean alreadyCreated(String lifecycleId) {
        LifecycleWrapper wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        return null != wrapper && wrapper.created;
    }

    Lifecycle verifyRegisterArgs(String lifecycleId, int phaseId, Phase phase) {
        String message = null;
        LifecycleWrapper wrapper = null;
        Lifecycle result = null;
        Object[] params = new Object[]{lifecycleId};
        if (null == lifecycleId || null == phase) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        if (null == wrapper) {
            message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_NOT_FOUND", params);
            log.severe("Error: " + message);
            throw new IllegalArgumentException(message);
        }
        result = wrapper.instance;
        Util.doAssert(null != result);
        if (this.alreadyCreated(lifecycleId)) {
            message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            log.severe("Error: " + message);
            throw new IllegalStateException(message);
        }
        if (FIRST_PHASE > phaseId || phaseId > LAST_PHASE) {
            params = new Object[]{Integer.toString(phaseId)};
            message = Util.getExceptionMessageString("com.sun.faces.PHASE_ID_OUT_OF_BOUNDS", params);
            log.severe("Error: " + message);
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null || lifecycle == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null != this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = Util.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            log.severe("addLifecycle: " + message);
            throw new IllegalArgumentException(message);
        }
        this.lifecycleMap.put(lifecycleId, new LifecycleWrapper(lifecycle, false));
        if (log.isLoggable(Level.FINE)) {
            log.fine("addedLifecycle: " + lifecycleId + " " + lifecycle);
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        Lifecycle result = null;
        LifecycleWrapper wrapper = null;
        if (null == lifecycleId) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (null == this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = Util.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", params);
            log.severe("LifecycleId " + lifecycleId + " does not exist");
            throw new IllegalArgumentException(message);
        }
        wrapper = (LifecycleWrapper)this.lifecycleMap.get(lifecycleId);
        result = wrapper.instance;
        wrapper.created = true;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("219) getLifecycle: " + lifecycleId + " " + result);
        }
        return result;
    }

    public Iterator getLifecycleIds() {
        return this.lifecycleMap.keySet().iterator();
    }

    static class LifecycleWrapper {
        Lifecycle instance = null;
        boolean created = false;

        LifecycleWrapper(Lifecycle newInstance, boolean newCreated) {
            this.instance = newInstance;
            this.created = newCreated;
        }
    }
}

